/*
 * Decompiled with CFR 0.152.
 */
package com.spichka.lineblock;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.spichka.lineblock.LineBlock;
import com.spichka.lineblock.lang.exceptions.ExceptionUtils;
import com.spichka.lineblock.lang.exceptions.LineBlockException;
import com.spichka.lineblock.lang.interpreter.Interpreter;
import com.spichka.lineblock.lang.lexer.Lexer;
import com.spichka.lineblock.lang.lexer.Token;
import com.spichka.lineblock.lang.parser.Parser;
import com.spichka.lineblock.lang.parser.ast.BlockNode;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

public class RunCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"run").then(class_2170.method_9244((String)"x", (ArgumentType)class_2262.method_9698()).executes(ctx -> RunCommand.execute((CommandContext<class_2168>)ctx)))));
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_2338 pos = class_2262.method_48299(context, (String)"x");
        class_3218 world = source.method_9225();
        try {
            LineBlock.LOGGER.info("1. Lexer");
            Lexer lexer = new Lexer((class_1937)world, pos, class_2350.field_11034);
            List<Token> tokens = lexer.tokenize();
            for (Token t : tokens) {
                LineBlock.LOGGER.info(t.toString());
            }
            LineBlock.LOGGER.info("2. Parser");
            Parser parser = new Parser((class_1937)world, tokens);
            BlockNode root = parser.parse();
            LineBlock.LOGGER.info(root.toString());
            LineBlock.LOGGER.info("3. Interpreter");
            Interpreter interpreter = new Interpreter(root, (class_1937)world);
            interpreter.interpret();
        }
        catch (LineBlockException e) {
            LineBlock.LOGGER.error("Error: ", (Throwable)e);
            ExceptionUtils.showError(source, e);
            return 0;
        }
        return 1;
    }
}

