/*
 * Decompiled with CFR 0.152.
 */
package com.spichka.lineblock.lang.interpreter;

import com.spichka.lineblock.lang.exceptions.LineBlockException;
import com.spichka.lineblock.lang.interpreter.Value;
import com.spichka.lineblock.lang.interpreter.Variable;
import com.spichka.lineblock.lang.lexer.Token;
import com.spichka.lineblock.lang.lexer.TokenType;
import com.spichka.lineblock.lang.parser.ast.AstNode;
import com.spichka.lineblock.lang.parser.ast.BinaryOpNode;
import com.spichka.lineblock.lang.parser.ast.BlockNode;
import com.spichka.lineblock.lang.parser.ast.CommandNode;
import com.spichka.lineblock.lang.parser.ast.ConstantNode;
import com.spichka.lineblock.lang.parser.ast.ForNode;
import com.spichka.lineblock.lang.parser.ast.IfNode;
import com.spichka.lineblock.lang.parser.ast.LiteralNode;
import com.spichka.lineblock.lang.parser.ast.PlaceBlockNode;
import com.spichka.lineblock.lang.parser.ast.UnaryOpNode;
import com.spichka.lineblock.lang.parser.ast.VariableNode;
import com.spichka.lineblock.lang.parser.ast.WhileNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1918;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2593;

public class Interpreter {
    private final AstNode root;
    private final class_1937 world;
    private int deepness;
    private List<Variable> variables;
    private boolean stopRunning;
    private boolean breakLoop;
    private boolean continueLoop;

    public Interpreter(AstNode root, class_1937 world) {
        this.root = root;
        this.world = world;
        this.deepness = 0;
        this.variables = new ArrayList<Variable>();
        this.stopRunning = false;
        this.breakLoop = false;
        this.continueLoop = false;
    }

    public void interpret() {
        this.visit(this.root);
    }

    private Value visit(AstNode node) {
        if (node instanceof VariableNode) {
            VariableNode n = (VariableNode)node;
            return this.visitVariable(n);
        }
        if (node instanceof LiteralNode) {
            LiteralNode n = (LiteralNode)node;
            return this.visitLiteral(n);
        }
        if (node instanceof BlockNode) {
            BlockNode n = (BlockNode)node;
            return this.visitBlock(n);
        }
        if (node instanceof CommandNode) {
            CommandNode n = (CommandNode)node;
            return this.visitCommand(n);
        }
        if (node instanceof UnaryOpNode) {
            UnaryOpNode n = (UnaryOpNode)node;
            return this.visitUnaryOp(n);
        }
        if (node instanceof BinaryOpNode) {
            BinaryOpNode n = (BinaryOpNode)node;
            return this.visitBinaryOp(n);
        }
        if (node instanceof ConstantNode) {
            ConstantNode n = (ConstantNode)node;
            return this.visitConstant(n);
        }
        if (node instanceof PlaceBlockNode) {
            PlaceBlockNode n = (PlaceBlockNode)node;
            return this.visitPlaceBlock(n);
        }
        if (node instanceof IfNode) {
            IfNode n = (IfNode)node;
            return this.visitIf(n);
        }
        if (node instanceof WhileNode) {
            WhileNode n = (WhileNode)node;
            return this.visitWhile(n);
        }
        if (node instanceof ForNode) {
            ForNode n = (ForNode)node;
            return this.visitFor(n);
        }
        throw new LineBlockException("Unknown AST node: " + node.getClass().getSimpleName());
    }

    private Value visitConstant(ConstantNode n) {
        if (n.constant.type == TokenType.PI) {
            return new Value(Value.Type.FLOAT, Float.valueOf((float)Math.PI));
        }
        if (n.constant.type == TokenType.E) {
            return new Value(Value.Type.FLOAT, Float.valueOf((float)Math.E));
        }
        throw new LineBlockException("Unknown constant: " + String.valueOf((Object)n.constant.type), n.constant);
    }

    private Value visitBlock(BlockNode n) {
        ++this.deepness;
        for (AstNode stmt : n.statements) {
            if (this.continueLoop || this.breakLoop || this.stopRunning) {
                this.continueLoop = false;
                break;
            }
            this.visit(stmt);
        }
        --this.deepness;
        this.variables.removeIf(v -> v.deepness > this.deepness);
        return null;
    }

    private Value visitIf(IfNode n) {
        Value conditionValue = this.visit(n.conditionNode);
        if (conditionValue.getType() == Value.Type.BOOL) {
            if (conditionValue.asBool()) {
                this.visit(n.thenBranchNode);
            } else if (n.elseBranchNode != null) {
                this.visit(n.elseBranchNode);
            }
        } else {
            throw new LineBlockException("If expects BOOL expression as condition");
        }
        return null;
    }

    private Value visitWhile(WhileNode n) {
        while (true) {
            Value conditionResult;
            if ((conditionResult = this.visit(n.conditionNode)).getType() != Value.Type.BOOL) {
                throw new LineBlockException("WHILE expects BOOL expression as condition");
            }
            if (!conditionResult.asBool() || this.breakLoop || this.stopRunning) break;
            this.visit(n.bodyNode);
        }
        this.breakLoop = false;
        return null;
    }

    private Value visitFor(ForNode n) {
        ++this.deepness;
        this.visit(n.initializerNode);
        while (true) {
            Value conditionResult;
            if ((conditionResult = this.visit(n.conditionNode)).getType() != Value.Type.BOOL) {
                throw new LineBlockException("FOR expects BOOL expression as condition");
            }
            if (!conditionResult.asBool() || this.breakLoop || this.stopRunning) break;
            this.visit(n.bodyNode);
            this.visit(n.incrementNode);
        }
        this.breakLoop = false;
        --this.deepness;
        this.variables.removeIf(v -> v.deepness >= this.deepness);
        return null;
    }

    private Value visitLiteral(LiteralNode n) {
        StringBuilder binary = new StringBuilder();
        for (Token bit : n.bits) {
            if (bit.type == TokenType.ZERO) {
                binary.append('0');
                continue;
            }
            if (bit.type == TokenType.ONE) {
                binary.append('1');
                continue;
            }
            throw new LineBlockException("Invalid bit in literal: " + String.valueOf((Object)bit.type), bit);
        }
        binary.reverse();
        String binString = binary.toString();
        int bitCount = binString.length();
        long longValue = Long.parseLong(binString, 2);
        switch (n.type.type) {
            case INT: {
                return new Value(Value.Type.INT, (int)longValue);
            }
            case FLOAT: {
                if (bitCount != 32) {
                    throw new LineBlockException("FLOAT literal must have exactly 32 bits", n.type);
                }
                int intBits = (int)longValue;
                float floatValue = Float.intBitsToFloat(intBits);
                return new Value(Value.Type.FLOAT, Float.valueOf(floatValue));
            }
            case BOOL: {
                return new Value(Value.Type.BOOL, longValue != 0L);
            }
            case STRING: {
                if (bitCount % 8 != 0) {
                    throw new LineBlockException("STRING literal bit length must be multiple of 8", n.type);
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < bitCount; i += 8) {
                    String byteStr = binString.substring(i, i + 8);
                    int byteVal = Integer.parseInt(byteStr, 2);
                    sb.append((char)byteVal);
                }
                return new Value(Value.Type.STRING, sb.toString());
            }
        }
        throw new LineBlockException("Unknown literal type: " + String.valueOf((Object)n.type.type), n.type);
    }

    private Value visitPlaceBlock(PlaceBlockNode n) {
        Value xValue = this.visit(n.x);
        Value yValue = this.visit(n.y);
        Value zValue = this.visit(n.z);
        if (xValue.getType() != Value.Type.INT || yValue.getType() != Value.Type.INT || zValue.getType() != Value.Type.INT) {
            throw new LineBlockException("PLACEBLOCK coordinates must be INT");
        }
        class_2338 pos = new class_2338(xValue.asInt(), yValue.asInt(), zValue.asInt());
        this.world.method_8652(pos, n.block.method_9564(), 3);
        return null;
    }

    private Value visitBinaryOp(BinaryOpNode n) {
        TokenType op = n.operator.type;
        if (op == TokenType.INT || op == TokenType.FLOAT || op == TokenType.BOOL || op == TokenType.STRING) {
            AstNode astNode = n.left;
            if (!(astNode instanceof VariableNode)) {
                throw new LineBlockException("Left side of assignment must be a variable", n.operator);
            }
            VariableNode varNode = (VariableNode)astNode;
            Value right = this.visit(n.right);
            Value.Type expectedType = switch (op) {
                case TokenType.INT -> Value.Type.INT;
                case TokenType.FLOAT -> Value.Type.FLOAT;
                case TokenType.BOOL -> Value.Type.BOOL;
                case TokenType.STRING -> Value.Type.STRING;
                default -> throw new LineBlockException("Unknown assign type: " + String.valueOf((Object)op), n.operator);
            };
            Value finalValue = this.castValue(right, expectedType, n.operator);
            int index = varNode.index.size();
            boolean updated = false;
            for (Variable v : this.variables) {
                if (v.index != index) continue;
                v.value = finalValue;
                updated = true;
                break;
            }
            if (!updated) {
                this.variables.add(new Variable(index, finalValue, this.deepness));
            }
            return finalValue;
        }
        Value left = this.visit(n.left);
        Value right = this.visit(n.right);
        switch (op) {
            case PLUS: {
                if (left.isNumber() && right.isNumber()) {
                    if (left.getType() == Value.Type.FLOAT || right.getType() == Value.Type.FLOAT) {
                        return new Value(Value.Type.FLOAT, Float.valueOf(left.toFloat() + right.toFloat()));
                    }
                    return new Value(Value.Type.INT, left.asInt() + right.asInt());
                }
                if (left.getType() == Value.Type.STRING || right.getType() == Value.Type.STRING) {
                    return new Value(Value.Type.STRING, left.toString() + right.toString());
                }
                throw new LineBlockException("PLUS expects numbers or strings", n.operator);
            }
            case MINUS: {
                if (left.isNumber() && right.isNumber()) {
                    if (left.getType() == Value.Type.FLOAT || right.getType() == Value.Type.FLOAT) {
                        return new Value(Value.Type.FLOAT, Float.valueOf(left.toFloat() - right.toFloat()));
                    }
                    return new Value(Value.Type.INT, left.asInt() - right.asInt());
                }
                throw new LineBlockException("MINUS expects numbers", n.operator);
            }
            case MUL: {
                if (left.isNumber() && right.isNumber()) {
                    if (left.getType() == Value.Type.FLOAT || right.getType() == Value.Type.FLOAT) {
                        return new Value(Value.Type.FLOAT, Float.valueOf(left.toFloat() * right.toFloat()));
                    }
                    return new Value(Value.Type.INT, left.asInt() * right.asInt());
                }
                if (left.getType() == Value.Type.STRING && right.getType() == Value.Type.INT) {
                    return new Value(Value.Type.STRING, left.asString().repeat(Math.max(0, right.asInt())));
                }
                if (right.getType() == Value.Type.STRING && left.getType() == Value.Type.INT) {
                    return new Value(Value.Type.STRING, right.asString().repeat(Math.max(0, left.asInt())));
                }
                throw new LineBlockException("MUL expects numbers or (string * int)", n.operator);
            }
            case DIV: {
                if (left.isNumber() && right.isNumber()) {
                    float divisor = right.toFloat();
                    if (divisor == 0.0f) {
                        throw new LineBlockException("Division by zero", n.operator);
                    }
                    return new Value(Value.Type.FLOAT, Float.valueOf(left.toFloat() / divisor));
                }
                throw new LineBlockException("DIV expects numbers", n.operator);
            }
            case MOD: {
                if (left.isNumber() && right.isNumber()) {
                    if (left.getType() == Value.Type.FLOAT || right.getType() == Value.Type.FLOAT) {
                        return new Value(Value.Type.FLOAT, Float.valueOf(left.toFloat() % right.toFloat()));
                    }
                    return new Value(Value.Type.INT, left.asInt() % right.asInt());
                }
                throw new LineBlockException("MOD expects numbers", n.operator);
            }
            case POW: {
                if (left.isNumber() && right.isNumber()) {
                    return new Value(Value.Type.FLOAT, Float.valueOf((float)Math.pow(left.toFloat(), right.toFloat())));
                }
                throw new LineBlockException("POW expects numbers", n.operator);
            }
            case BIT_AND: {
                if (left.getType() == Value.Type.INT && right.getType() == Value.Type.INT) {
                    return new Value(Value.Type.INT, left.asInt() & right.asInt());
                }
                throw new LineBlockException("BIT_AND expects INT", n.operator);
            }
            case BIT_OR: {
                if (left.getType() == Value.Type.INT && right.getType() == Value.Type.INT) {
                    return new Value(Value.Type.INT, left.asInt() | right.asInt());
                }
                throw new LineBlockException("BIT_OR expects INT", n.operator);
            }
            case BIT_XOR: {
                if (left.getType() == Value.Type.INT && right.getType() == Value.Type.INT) {
                    return new Value(Value.Type.INT, left.asInt() ^ right.asInt());
                }
                throw new LineBlockException("BIT_XOR expects INT", n.operator);
            }
            case SHL: {
                if (left.getType() == Value.Type.INT && right.getType() == Value.Type.INT) {
                    return new Value(Value.Type.INT, left.asInt() << right.asInt());
                }
                throw new LineBlockException("SHL expects INT", n.operator);
            }
            case SHR: {
                if (left.getType() == Value.Type.INT && right.getType() == Value.Type.INT) {
                    return new Value(Value.Type.INT, left.asInt() >> right.asInt());
                }
                throw new LineBlockException("SHR expects INT", n.operator);
            }
            case AND: {
                if (left.getType() == Value.Type.BOOL && right.getType() == Value.Type.BOOL) {
                    return new Value(Value.Type.BOOL, left.asBool() && right.asBool());
                }
                throw new LineBlockException("AND expects BOOL", n.operator);
            }
            case OR: {
                if (left.getType() == Value.Type.BOOL && right.getType() == Value.Type.BOOL) {
                    return new Value(Value.Type.BOOL, left.asBool() || right.asBool());
                }
                throw new LineBlockException("OR expects BOOL", n.operator);
            }
            case XOR: {
                if (left.getType() == Value.Type.BOOL && right.getType() == Value.Type.BOOL) {
                    return new Value(Value.Type.BOOL, left.asBool() ^ right.asBool());
                }
                throw new LineBlockException("XOR expects BOOL", n.operator);
            }
            case EQ: {
                return new Value(Value.Type.BOOL, left.equalsValue(right));
            }
            case NE: {
                return new Value(Value.Type.BOOL, !left.equalsValue(right));
            }
            case GT: {
                if (left.isNumber() && right.isNumber()) {
                    return new Value(Value.Type.BOOL, left.toFloat() > right.toFloat());
                }
                throw new LineBlockException("GT expects numbers", n.operator);
            }
            case LT: {
                if (left.isNumber() && right.isNumber()) {
                    return new Value(Value.Type.BOOL, left.toFloat() < right.toFloat());
                }
                throw new LineBlockException("LT expects numbers", n.operator);
            }
            case GE: {
                if (left.isNumber() && right.isNumber()) {
                    return new Value(Value.Type.BOOL, left.toFloat() >= right.toFloat());
                }
                throw new LineBlockException("GE expects numbers", n.operator);
            }
            case LE: {
                if (left.isNumber() && right.isNumber()) {
                    return new Value(Value.Type.BOOL, left.toFloat() <= right.toFloat());
                }
                throw new LineBlockException("LE expects numbers", n.operator);
            }
        }
        throw new LineBlockException("Unknown binary operator: " + String.valueOf((Object)op), n.operator);
    }

    private Value castValue(Value v, Value.Type expected, Token op) {
        if (v.getType() == expected) {
            return v;
        }
        return switch (expected) {
            default -> throw new IncompatibleClassChangeError();
            case Value.Type.INT -> {
                if (v.getType() == Value.Type.FLOAT) {
                    Value var4_4;
                    yield var4_4 = new Value(Value.Type.INT, (int)v.asFloat());
                }
                if (v.getType() == Value.Type.BOOL) {
                    Value var4_5;
                    yield var4_5 = new Value(Value.Type.INT, v.asBool() ? 1 : 0);
                }
                if (v.getType() == Value.Type.STRING) {
                    try {
                        Value var4_6;
                        yield var4_6 = new Value(Value.Type.INT, Integer.parseInt(v.asString()));
                    }
                    catch (NumberFormatException e) {
                        throw new LineBlockException("Cannot convert STRING to INT", op);
                    }
                }
                throw new LineBlockException("Cannot convert " + String.valueOf((Object)v.getType()) + " to INT", op);
            }
            case Value.Type.FLOAT -> {
                if (v.getType() == Value.Type.INT) {
                    Value var4_7;
                    yield var4_7 = new Value(Value.Type.FLOAT, Float.valueOf(v.asInt()));
                }
                if (v.getType() == Value.Type.BOOL) {
                    Value var4_8;
                    yield var4_8 = new Value(Value.Type.FLOAT, Float.valueOf(v.asBool() ? 1.0f : 0.0f));
                }
                if (v.getType() == Value.Type.STRING) {
                    try {
                        Value var4_9;
                        yield var4_9 = new Value(Value.Type.FLOAT, Float.valueOf(Float.parseFloat(v.asString())));
                    }
                    catch (NumberFormatException e) {
                        throw new LineBlockException("Cannot convert STRING to FLOAT", op);
                    }
                }
                throw new LineBlockException("Cannot convert " + String.valueOf((Object)v.getType()) + " to FLOAT", op);
            }
            case Value.Type.BOOL -> {
                if (v.isNumber()) {
                    Value var4_10;
                    yield var4_10 = new Value(Value.Type.BOOL, v.toFloat() != 0.0f);
                }
                if (v.getType() == Value.Type.STRING) {
                    Value var4_11;
                    yield var4_11 = new Value(Value.Type.BOOL, !v.asString().isEmpty());
                }
                throw new LineBlockException("Cannot convert " + String.valueOf((Object)v.getType()) + " to BOOL", op);
            }
            case Value.Type.STRING -> {
                Value var4_12;
                yield var4_12 = new Value(Value.Type.STRING, v.toString());
            }
        };
    }

    private Value visitCommand(CommandNode n) {
        if (n.token.type == TokenType.COMMAND) {
            class_2338 pos = n.token.pos;
            class_2586 blockEntity = this.world.method_8321(pos);
            if (!(blockEntity instanceof class_2593)) {
                throw new LineBlockException("No command block found at " + String.valueOf(pos), n.token);
            }
            class_2593 commandBlock = (class_2593)blockEntity;
            class_1918 executor = commandBlock.method_11040();
            executor.method_8301(this.world);
        } else if (n.token.type == TokenType.STOP) {
            this.stopRunning = true;
        } else if (n.token.type == TokenType.BREAK) {
            this.breakLoop = true;
        } else if (n.token.type == TokenType.CONTINUE) {
            this.continueLoop = true;
        }
        return null;
    }

    private Value visitUnaryOp(UnaryOpNode n) {
        Value value = this.visit(n.operand);
        TokenType op = n.operator.type;
        switch (op) {
            case PRINT: {
                if (!this.world.method_18456().isEmpty()) {
                    class_1657 player = (class_1657)this.world.method_18456().get(0);
                    player.method_7353((class_2561)class_2561.method_43470((String)value.toString()), false);
                }
                return null;
            }
            case PLUS: {
                if (value.isNumber()) {
                    return value;
                }
                throw new LineBlockException("PLUS expects a number", n.operator);
            }
            case MINUS: {
                if (value.getType() == Value.Type.INT) {
                    return new Value(Value.Type.INT, -value.asInt());
                }
                if (value.getType() == Value.Type.FLOAT) {
                    return new Value(Value.Type.FLOAT, Float.valueOf(-value.asFloat()));
                }
                throw new LineBlockException("MINUS expects INT or FLOAT", n.operator);
            }
            case BIT_NOT: {
                if (value.getType() == Value.Type.INT) {
                    return new Value(Value.Type.INT, ~value.asInt());
                }
                throw new LineBlockException("BIT_NOT expects INT", n.operator);
            }
            case NOT: {
                if (value.getType() == Value.Type.BOOL) {
                    return new Value(Value.Type.BOOL, !value.asBool());
                }
                throw new LineBlockException("NOT expects BOOL", n.operator);
            }
            case SIN: {
                if (value.isNumber()) {
                    return new Value(Value.Type.FLOAT, Float.valueOf((float)Math.sin(value.toFloat())));
                }
                throw new LineBlockException("SIN expects INT or FLOAT", n.operator);
            }
            case COS: {
                if (value.isNumber()) {
                    return new Value(Value.Type.FLOAT, Float.valueOf((float)Math.cos(value.toFloat())));
                }
                throw new LineBlockException("COS expects INT or FLOAT", n.operator);
            }
            case TAN: {
                if (value.isNumber()) {
                    return new Value(Value.Type.FLOAT, Float.valueOf((float)Math.tan(value.toFloat())));
                }
                throw new LineBlockException("TAN expects INT or FLOAT", n.operator);
            }
            case ASIN: {
                if (value.isNumber()) {
                    return new Value(Value.Type.FLOAT, Float.valueOf((float)Math.asin(value.toFloat())));
                }
                throw new LineBlockException("ASIN expects INT or FLOAT", n.operator);
            }
            case ACOS: {
                if (value.isNumber()) {
                    return new Value(Value.Type.FLOAT, Float.valueOf((float)Math.acos(value.toFloat())));
                }
                throw new LineBlockException("ACOS expects INT or FLOAT", n.operator);
            }
            case ATAN: {
                if (value.isNumber()) {
                    return new Value(Value.Type.FLOAT, Float.valueOf((float)Math.atan(value.toFloat())));
                }
                throw new LineBlockException("ATAN expects INT or FLOAT", n.operator);
            }
            case ABS: {
                if (value.getType() == Value.Type.INT) {
                    return new Value(Value.Type.INT, Math.abs(value.asInt()));
                }
                if (value.getType() == Value.Type.FLOAT) {
                    return new Value(Value.Type.FLOAT, Float.valueOf(Math.abs(value.asFloat())));
                }
                throw new LineBlockException("ABS expects INT or FLOAT", n.operator);
            }
            case CEIL: {
                if (value.isNumber()) {
                    return new Value(Value.Type.FLOAT, Float.valueOf((float)Math.ceil(value.toFloat())));
                }
                throw new LineBlockException("CEIL expects INT or FLOAT", n.operator);
            }
            case FLOOR: {
                if (value.isNumber()) {
                    return new Value(Value.Type.FLOAT, Float.valueOf((float)Math.floor(value.toFloat())));
                }
                throw new LineBlockException("FLOOR expects INT or FLOAT", n.operator);
            }
        }
        throw new LineBlockException("Unknown unary operator: " + String.valueOf((Object)op), n.operator);
    }

    private Value visitVariable(VariableNode n) {
        int index = n.index.size();
        for (Variable var : this.variables) {
            if (var.index != index) continue;
            return var.value;
        }
        throw new LineBlockException("Variable with index " + index + " not found");
    }
}

