/*
 * Decompiled with CFR 0.152.
 */
package com.spichka.lineblock.lang.interpreter;

import com.spichka.lineblock.lang.exceptions.LineBlockException;

public class Value {
    private final Type type;
    private final Object value;

    public Value(Type type, Object value) {
        this.type = type;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public int asInt() {
        return (Integer)this.value;
    }

    public float asFloat() {
        return ((Float)this.value).floatValue();
    }

    public String asString() {
        return (String)this.value;
    }

    public boolean asBool() {
        return (Boolean)this.value;
    }

    public float toFloat() {
        if (this.type == Type.FLOAT) {
            return ((Float)this.value).floatValue();
        }
        if (this.type == Type.INT) {
            return ((Integer)this.value).intValue();
        }
        throw new LineBlockException("Cannot convert type to float", null);
    }

    public boolean isNumber() {
        return this.type == Type.INT || this.type == Type.FLOAT;
    }

    public boolean equalsValue(Value other) {
        if (this.type != other.type) {
            return false;
        }
        return switch (this.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                if (((Integer)this.value).intValue() == ((Integer)other.value).intValue()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if ((double)Math.abs(((Float)this.value).floatValue() - ((Float)other.value).floatValue()) < 1.0E-6) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (((Boolean)this.value).booleanValue() == ((Boolean)other.value).booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> ((String)this.value).equals((String)other.value);
        };
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static enum Type {
        INT,
        FLOAT,
        STRING,
        BOOL;

    }
}

