/*
 * Decompiled with CFR 0.152.
 */
package com.spichka.lineblock.lang.parser;

import com.spichka.lineblock.lang.exceptions.LineBlockException;
import com.spichka.lineblock.lang.lexer.Token;
import com.spichka.lineblock.lang.lexer.TokenType;
import com.spichka.lineblock.lang.parser.ast.AstNode;
import com.spichka.lineblock.lang.parser.ast.BinaryOpNode;
import com.spichka.lineblock.lang.parser.ast.BlockNode;
import com.spichka.lineblock.lang.parser.ast.CommandNode;
import com.spichka.lineblock.lang.parser.ast.ConstantNode;
import com.spichka.lineblock.lang.parser.ast.ForNode;
import com.spichka.lineblock.lang.parser.ast.IfNode;
import com.spichka.lineblock.lang.parser.ast.LiteralNode;
import com.spichka.lineblock.lang.parser.ast.PlaceBlockNode;
import com.spichka.lineblock.lang.parser.ast.UnaryOpNode;
import com.spichka.lineblock.lang.parser.ast.VariableNode;
import com.spichka.lineblock.lang.parser.ast.WhileNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class Parser {
    private final List<Token> tokens;
    private final class_1937 world;
    private Token currentToken;
    private int position;

    public Parser(class_1937 world, List<Token> tokens) {
        this.tokens = tokens;
        this.world = world;
        this.position = 0;
    }

    public BlockNode parse() {
        BlockNode root = new BlockNode();
        while (this.position < this.tokens.size()) {
            AstNode codeLineNode = this.parseLine();
            root.addStatement(codeLineNode);
        }
        return root;
    }

    private Token match(List<TokenType> types) {
        if (this.position < this.tokens.size()) {
            Token currentToken = this.tokens.get(this.position);
            if (types.contains((Object)currentToken.type)) {
                ++this.position;
                this.currentToken = currentToken;
                return currentToken;
            }
        }
        return null;
    }

    private Token require(List<TokenType> types) {
        Token token = this.match(types);
        if (token == null) {
            throw new LineBlockException("One of " + String.valueOf(types) + " required", this.currentToken);
        }
        return token;
    }

    private AstNode parseLine() {
        if (this.match(List.of(TokenType.INT, TokenType.STRING, TokenType.FLOAT, TokenType.BOOL)) != null) {
            return this.parseVariable();
        }
        if (this.match(List.of(TokenType.COMMAND, TokenType.STOP, TokenType.BREAK, TokenType.CONTINUE)) != null) {
            return new CommandNode(this.currentToken);
        }
        if (this.match(List.of(TokenType.PRINT)) != null) {
            Token operator = this.currentToken;
            return new UnaryOpNode(operator, this.parseExpression());
        }
        if (this.match(List.of(TokenType.PLACEBLOCK)) != null) {
            return this.parsePlaceBlock();
        }
        if (this.match(List.of(TokenType.IF)) != null) {
            return this.parseIf();
        }
        if (this.match(List.of(TokenType.WHILE)) != null) {
            return this.parseWhile();
        }
        if (this.match(List.of(TokenType.FOR)) != null) {
            return this.parseFor();
        }
        throw new LineBlockException("Wrong block", this.currentToken);
    }

    private AstNode parseVariable() {
        AstNode expressionNode;
        VariableNode variableNode;
        Token assign = this.currentToken;
        if (this.match(List.of(TokenType.VAR_INDEX)) != null) {
            ArrayList<Token> varIndexTokens = new ArrayList<Token>();
            varIndexTokens.add(this.currentToken);
            varIndexTokens.addAll(this.collectTokens(List.of(TokenType.VAR_INDEX)));
            variableNode = new VariableNode(varIndexTokens);
            expressionNode = this.parseExpression();
        } else {
            expressionNode = this.parseExpression();
            variableNode = new VariableNode(this.collectTokens(List.of(TokenType.VAR_INDEX)));
        }
        BinaryOpNode binaryOpNode = new BinaryOpNode(assign, variableNode, expressionNode);
        return binaryOpNode;
    }

    private AstNode parseTerm() {
        AstNode node = this.parseFactor();
        while (this.match(List.of(TokenType.MUL, TokenType.DIV, TokenType.MOD, TokenType.POW, TokenType.BIT_AND, TokenType.BIT_OR, TokenType.BIT_XOR, TokenType.SHL, TokenType.SHR)) != null) {
            Token token = this.currentToken;
            node = new BinaryOpNode(token, node, this.parseFactor());
        }
        return node;
    }

    private AstNode parseFactor() {
        if (this.match(List.of(TokenType.PLUS, TokenType.MINUS, TokenType.NOT, TokenType.BIT_NOT, TokenType.SIN, TokenType.COS, TokenType.TAN, TokenType.ASIN, TokenType.ACOS, TokenType.ATAN, TokenType.ABS, TokenType.CEIL, TokenType.FLOOR)) != null) {
            Token operator = this.currentToken;
            return new UnaryOpNode(operator, this.parseFactor());
        }
        if (this.match(List.of(TokenType.LPAR)) != null) {
            AstNode node = this.parseExpression();
            this.require(List.of(TokenType.RPAR));
            return node;
        }
        if (this.match(List.of(TokenType.INT, TokenType.FLOAT, TokenType.STRING, TokenType.BOOL)) != null) {
            Token type = this.currentToken;
            LiteralNode literal = new LiteralNode(type, this.collectTokens(List.of(TokenType.ZERO, TokenType.ONE)));
            if (literal.bits.size() == 0) {
                throw new LineBlockException("No bits for literal", type);
            }
            return literal;
        }
        if (this.match(List.of(TokenType.USE_VAR)) != null) {
            return new VariableNode(this.collectTokens(List.of(TokenType.VAR_INDEX)));
        }
        if (this.match(List.of(TokenType.PI, TokenType.E)) != null) {
            return new ConstantNode(this.currentToken);
        }
        throw new LineBlockException("Expected another value", this.currentToken);
    }

    private AstNode parseExpression() {
        AstNode node = this.parseTerm();
        while (this.match(List.of(TokenType.PLUS, TokenType.MINUS, TokenType.AND, TokenType.OR, TokenType.XOR, TokenType.LT, TokenType.GT, TokenType.LE, TokenType.GE, TokenType.EQ, TokenType.NE)) != null) {
            Token token = this.currentToken;
            node = new BinaryOpNode(token, node, this.parseTerm());
        }
        return node;
    }

    private List<Token> collectTokens(List<TokenType> validTypes) {
        ArrayList<Token> collected = new ArrayList<Token>();
        while (this.position < this.tokens.size() && this.match(validTypes) != null) {
            collected.add(this.currentToken);
        }
        return collected;
    }

    private AstNode parsePlaceBlock() {
        AstNode placeX = null;
        AstNode placeY = null;
        AstNode placeZ = null;
        class_2338 placeBlockPos = this.currentToken.pos;
        class_2338 fourthArgumentPos = null;
        for (int i = 0; i < 4; ++i) {
            if (this.match(List.of(TokenType.FIRST_ARGUMENT, TokenType.SECOND_ARGUMENT, TokenType.THRID_ARGUMENT, TokenType.FOURTH_ARGUMENT)) != null) {
                Token argToken = this.currentToken;
                switch (argToken.type) {
                    case FIRST_ARGUMENT: {
                        placeX = this.parseExpression();
                        break;
                    }
                    case SECOND_ARGUMENT: {
                        placeY = this.parseExpression();
                        break;
                    }
                    case THRID_ARGUMENT: {
                        placeZ = this.parseExpression();
                        break;
                    }
                    case FOURTH_ARGUMENT: {
                        fourthArgumentPos = argToken.pos;
                        break;
                    }
                }
                continue;
            }
            ++this.position;
            --i;
        }
        int x = fourthArgumentPos.method_10263() + (fourthArgumentPos.method_10263() - placeBlockPos.method_10263());
        int y = fourthArgumentPos.method_10264() + (fourthArgumentPos.method_10264() - placeBlockPos.method_10264());
        int z = fourthArgumentPos.method_10260() + (fourthArgumentPos.method_10260() - placeBlockPos.method_10260());
        class_2338 pos = new class_2338(new class_2382(x, y, z));
        return new PlaceBlockNode(placeX, placeY, placeZ, this.world.method_8320(pos).method_26204());
    }

    private AstNode parseBlock() {
        BlockNode root = new BlockNode();
        while (this.match(List.of(TokenType.BLOCK_END)) == null) {
            AstNode codeLineNode = this.parseLine();
            root.addStatement(codeLineNode);
        }
        return root;
    }

    private AstNode parseIf() {
        AstNode conditionNode = null;
        AstNode thenBranchNode = null;
        AstNode elseBranchNode = null;
        block5: for (int i = 0; i < 3 && this.match(List.of(TokenType.FIRST_ARGUMENT, TokenType.SECOND_ARGUMENT, TokenType.THRID_ARGUMENT)) != null; ++i) {
            Token argToken = this.currentToken;
            switch (argToken.type) {
                case FIRST_ARGUMENT: {
                    conditionNode = this.parseExpression();
                    continue block5;
                }
                case SECOND_ARGUMENT: {
                    thenBranchNode = this.parseBlock();
                    continue block5;
                }
                case THRID_ARGUMENT: {
                    elseBranchNode = this.parseBlock();
                    continue block5;
                }
            }
        }
        return new IfNode(conditionNode, thenBranchNode, elseBranchNode);
    }

    private AstNode parseWhile() {
        Token whileToken = this.currentToken;
        AstNode conditionNode = null;
        AstNode bodyNode = null;
        for (int i = 0; i < 2; ++i) {
            if (this.match(List.of(TokenType.FIRST_ARGUMENT, TokenType.SECOND_ARGUMENT)) != null) {
                Token argToken = this.currentToken;
                switch (argToken.type) {
                    case FIRST_ARGUMENT: {
                        conditionNode = this.parseExpression();
                        break;
                    }
                    case SECOND_ARGUMENT: {
                        bodyNode = this.parseBlock();
                        break;
                    }
                }
                continue;
            }
            throw new LineBlockException("WHILE expects 2 arguments", whileToken);
        }
        return new WhileNode(conditionNode, bodyNode);
    }

    private AstNode parseFor() {
        Token forToken = this.currentToken;
        AstNode initNode = null;
        AstNode conditionNode = null;
        AstNode incrementNode = null;
        AstNode bodyNode = null;
        for (int i = 0; i < 4; ++i) {
            if (this.match(List.of(TokenType.FIRST_ARGUMENT, TokenType.SECOND_ARGUMENT, TokenType.THRID_ARGUMENT, TokenType.FOURTH_ARGUMENT)) != null) {
                Token argToken = this.currentToken;
                switch (argToken.type) {
                    case FIRST_ARGUMENT: {
                        this.require(List.of(TokenType.INT, TokenType.FLOAT, TokenType.STRING, TokenType.BOOL));
                        initNode = this.parseVariable();
                        break;
                    }
                    case SECOND_ARGUMENT: {
                        conditionNode = this.parseExpression();
                        break;
                    }
                    case THRID_ARGUMENT: {
                        this.require(List.of(TokenType.INT, TokenType.FLOAT, TokenType.STRING, TokenType.BOOL));
                        incrementNode = this.parseVariable();
                        break;
                    }
                    case FOURTH_ARGUMENT: {
                        bodyNode = this.parseBlock();
                        break;
                    }
                }
                continue;
            }
            throw new LineBlockException("FOR expects 4 arguments", forToken);
        }
        return new ForNode(initNode, conditionNode, incrementNode, bodyNode);
    }
}

