/*
 * Decompiled with CFR 0.152.
 */
package ru.art3m4ik3.randomEffects;

import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.art3m4ik3.randomEffects.commands.RandomEffectsCommand;
import ru.art3m4ik3.randomEffects.listeners.ChunkChangeListener;
import ru.art3m4ik3.randomEffects.listeners.PlayerJoinListener;
import ru.art3m4ik3.randomEffects.managers.ConfigManager;
import ru.art3m4ik3.randomEffects.managers.EffectManager;
import ru.art3m4ik3.randomEffects.managers.LanguageManager;
import ru.art3m4ik3.randomEffects.tasks.TimedEffectTask;

public final class RandomEffects
extends JavaPlugin {
    private static RandomEffects instance;
    private ConfigManager configManager;
    private LanguageManager languageManager;
    private EffectManager effectManager;
    private TimedEffectTask timedEffectTask;
    private Logger logger;

    public void onEnable() {
        instance = this;
        this.logger = this.getLogger();
        this.logger.info("Initializing RandomEffects plugin...");
        this.configManager = new ConfigManager(this);
        this.languageManager = new LanguageManager(this);
        this.effectManager = new EffectManager(this);
        this.getCommand("randomeffects").setExecutor((CommandExecutor)new RandomEffectsCommand(this));
        Bukkit.getPluginManager().registerEvents((Listener)new ChunkChangeListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        if (this.configManager.isTimedModeEnabled()) {
            this.startTimedEffects();
        }
        this.logger.info("RandomEffects plugin has been enabled!");
    }

    public void onDisable() {
        this.logger.info("Disabling RandomEffects plugin...");
        if (this.timedEffectTask != null) {
            this.timedEffectTask.cancel();
        }
        this.configManager.saveConfig();
        this.logger.info("RandomEffects plugin has been disabled!");
    }

    public void startTimedEffects() {
        if (this.timedEffectTask != null) {
            this.timedEffectTask.cancel();
        }
        int interval = this.configManager.getTimedInterval();
        this.timedEffectTask = new TimedEffectTask(this);
        this.timedEffectTask.runTaskTimer((Plugin)this, 20L, (long)interval * 20L);
        this.logger.info("Timed effects started with interval: " + interval + " seconds");
    }

    public void stopTimedEffects() {
        if (this.timedEffectTask != null) {
            this.timedEffectTask.cancel();
            this.timedEffectTask = null;
            this.logger.info("Timed effects stopped");
        }
    }

    public void reload() {
        this.configManager.reloadConfig();
        this.languageManager.reloadLanguage();
        if (this.configManager.isTimedModeEnabled()) {
            this.startTimedEffects();
        } else {
            this.stopTimedEffects();
        }
        this.logger.info("Plugin configuration reloaded");
    }

    public static RandomEffects getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public EffectManager getEffectManager() {
        return this.effectManager;
    }
}

