/*
 * Decompiled with CFR 0.152.
 */
package ru.art3m4ik3.randomEffects.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import ru.art3m4ik3.randomEffects.RandomEffects;
import ru.art3m4ik3.randomEffects.managers.LanguageManager;

public class RandomEffectsCommand
implements CommandExecutor,
TabCompleter {
    private final RandomEffects plugin;

    public RandomEffectsCommand(RandomEffects plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String subCommand;
        LanguageManager lang = this.plugin.getLanguageManager();
        if (args.length == 0) {
            this.sendPluginInfo(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                if (!this.hasPermission(sender, "randomeffects.admin.reload")) {
                    sender.sendMessage(lang.getFormattedMessage("commands.noPermission"));
                    return true;
                }
                this.plugin.reload();
                sender.sendMessage(lang.getFormattedMessage("commands.reload.success"));
                return true;
            }
            case "apply": {
                if (!this.hasPermission(sender, "randomeffects.admin.apply")) {
                    sender.sendMessage(lang.getFormattedMessage("commands.noPermission"));
                    return true;
                }
                if (args.length >= 2 && args[1].equalsIgnoreCase("all")) {
                    this.plugin.getEffectManager().applyRandomEffectsToAll();
                    sender.sendMessage(lang.getFormattedMessage("commands.apply.all"));
                } else if (args.length >= 2) {
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target == null || !target.isOnline()) {
                        sender.sendMessage(lang.getFormattedMessage("commands.playerNotFound"));
                        return true;
                    }
                    this.plugin.getEffectManager().applyRandomEffects(target);
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("player", target.getName());
                    sender.sendMessage(lang.getFormattedMessage("commands.apply.player", placeholders));
                } else if (sender instanceof Player) {
                    Player player = (Player)sender;
                    this.plugin.getEffectManager().applyRandomEffects(player);
                    sender.sendMessage(lang.getFormattedMessage("commands.apply.self"));
                } else {
                    sender.sendMessage(lang.getFormattedMessage("commands.specifyPlayer"));
                }
                return true;
            }
            case "clear": {
                if (!this.hasPermission(sender, "randomeffects.admin.clear")) {
                    sender.sendMessage(lang.getFormattedMessage("commands.noPermission"));
                    return true;
                }
                if (args.length >= 2 && args[1].equalsIgnoreCase("all")) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        this.plugin.getEffectManager().clearEffects(player);
                    }
                    sender.sendMessage(lang.getFormattedMessage("commands.clear.all"));
                } else if (args.length >= 2) {
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target == null || !target.isOnline()) {
                        sender.sendMessage(lang.getFormattedMessage("commands.playerNotFound"));
                        return true;
                    }
                    this.plugin.getEffectManager().clearEffects(target);
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("player", target.getName());
                    sender.sendMessage(lang.getFormattedMessage("commands.clear.player", placeholders));
                } else if (sender instanceof Player) {
                    Player player = (Player)sender;
                    this.plugin.getEffectManager().clearEffects(player);
                    sender.sendMessage(lang.getFormattedMessage("commands.clear.self"));
                } else {
                    sender.sendMessage(lang.getFormattedMessage("commands.specifyPlayer"));
                }
                return true;
            }
            case "toggle": {
                String toggleOption;
                if (!this.hasPermission(sender, "randomeffects.admin.toggle")) {
                    sender.sendMessage(lang.getFormattedMessage("commands.noPermission"));
                    return true;
                }
                if (args.length < 2) {
                    this.sendUsage(sender, "toggle");
                    return true;
                }
                switch (toggleOption = args[1].toLowerCase()) {
                    case "timed": {
                        boolean timedEnabled = !this.plugin.getConfigManager().isTimedModeEnabled();
                        this.plugin.getConfigManager().setTimedModeEnabled(timedEnabled);
                        if (timedEnabled) {
                            this.plugin.startTimedEffects();
                            sender.sendMessage(lang.getFormattedMessage("commands.toggle.timed.enabled"));
                        } else {
                            this.plugin.stopTimedEffects();
                            sender.sendMessage(lang.getFormattedMessage("commands.toggle.timed.disabled"));
                        }
                        this.plugin.getConfigManager().saveConfig();
                        break;
                    }
                    case "chunk": {
                        boolean chunkEnabled = !this.plugin.getConfigManager().isChunkModeEnabled();
                        this.plugin.getConfigManager().setChunkModeEnabled(chunkEnabled);
                        if (chunkEnabled) {
                            sender.sendMessage(lang.getFormattedMessage("commands.toggle.chunk.enabled"));
                        } else {
                            sender.sendMessage(lang.getFormattedMessage("commands.toggle.chunk.disabled"));
                        }
                        this.plugin.getConfigManager().saveConfig();
                        break;
                    }
                    case "notify": {
                        boolean notifyEnabled = !this.plugin.getConfigManager().isNotifyPlayers();
                        this.plugin.getConfigManager().setNotifyPlayers(notifyEnabled);
                        if (notifyEnabled) {
                            sender.sendMessage(lang.getFormattedMessage("commands.toggle.notify.enabled"));
                        } else {
                            sender.sendMessage(lang.getFormattedMessage("commands.toggle.notify.disabled"));
                        }
                        this.plugin.getConfigManager().saveConfig();
                        break;
                    }
                    default: {
                        this.sendUsage(sender, "toggle");
                        return true;
                    }
                }
                return true;
            }
            case "interval": {
                if (!this.hasPermission(sender, "randomeffects.admin.interval")) {
                    sender.sendMessage(lang.getFormattedMessage("commands.noPermission"));
                    return true;
                }
                if (args.length < 2) {
                    int currentInterval = this.plugin.getConfigManager().getTimedInterval();
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("seconds", String.valueOf(currentInterval));
                    sender.sendMessage(lang.getFormattedMessage("commands.interval.current", placeholders));
                    return true;
                }
                try {
                    int newInterval = Integer.parseInt(args[1]);
                    if (newInterval < 1) {
                        sender.sendMessage(lang.getFormattedMessage("commands.interval.tooSmall"));
                        return true;
                    }
                    this.plugin.getConfigManager().setTimedInterval(newInterval);
                    this.plugin.getConfigManager().saveConfig();
                    if (this.plugin.getConfigManager().isTimedModeEnabled()) {
                        this.plugin.startTimedEffects();
                    }
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("seconds", String.valueOf(newInterval));
                    sender.sendMessage(lang.getFormattedMessage("commands.interval.updated", placeholders));
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(lang.getFormattedMessage("commands.interval.invalid"));
                }
                return true;
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private void sendPluginInfo(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== RandomEffects v" + this.plugin.getDescription().getVersion() + " ===");
        sender.sendMessage("\u00a77Developed by \u00a7b" + String.join((CharSequence)", ", this.plugin.getDescription().getAuthors()));
        sender.sendMessage("\u00a77Type \u00a7b/randomeffects help \u00a77for available commands");
    }

    private void sendHelp(CommandSender sender) {
        LanguageManager lang = this.plugin.getLanguageManager();
        sender.sendMessage("\u00a76\u00a7l=== RandomEffects Commands ===");
        if (this.hasPermission(sender, "randomeffects.admin.reload")) {
            sender.sendMessage("\u00a7b/randomeffects reload \u00a77- " + lang.getMessage("help.reload"));
        }
        if (this.hasPermission(sender, "randomeffects.admin.apply")) {
            sender.sendMessage("\u00a7b/randomeffects apply [player|all] \u00a77- " + lang.getMessage("help.apply"));
        }
        if (this.hasPermission(sender, "randomeffects.admin.clear")) {
            sender.sendMessage("\u00a7b/randomeffects clear [player|all] \u00a77- " + lang.getMessage("help.clear"));
        }
        if (this.hasPermission(sender, "randomeffects.admin.toggle")) {
            sender.sendMessage("\u00a7b/randomeffects toggle <timed|chunk|notify> \u00a77- " + lang.getMessage("help.toggle"));
        }
        if (this.hasPermission(sender, "randomeffects.admin.interval")) {
            sender.sendMessage("\u00a7b/randomeffects interval [seconds] \u00a77- " + lang.getMessage("help.interval"));
        }
    }

    private void sendUsage(CommandSender sender, String subCommand) {
        LanguageManager lang = this.plugin.getLanguageManager();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("command", subCommand);
        sender.sendMessage(lang.getFormattedMessage("commands.usage." + subCommand, placeholders));
    }

    private boolean hasPermission(CommandSender sender, String permission) {
        return sender.hasPermission(permission) || sender.isOp();
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            ArrayList<String> subCommands = new ArrayList<String>();
            if (this.hasPermission(sender, "randomeffects.admin.reload")) {
                subCommands.add("reload");
            }
            if (this.hasPermission(sender, "randomeffects.admin.apply")) {
                subCommands.add("apply");
            }
            if (this.hasPermission(sender, "randomeffects.admin.clear")) {
                subCommands.add("clear");
            }
            if (this.hasPermission(sender, "randomeffects.admin.toggle")) {
                subCommands.add("toggle");
            }
            if (this.hasPermission(sender, "randomeffects.admin.interval")) {
                subCommands.add("interval");
            }
            subCommands.add("help");
            return this.filterCompletions(subCommands, args[0]);
        }
        if (args.length == 2) {
            String subCommand;
            switch (subCommand = args[0].toLowerCase()) {
                case "apply": 
                case "clear": {
                    if (!this.hasPermission(sender, "randomeffects.admin." + subCommand)) break;
                    ArrayList<String> options = new ArrayList<String>();
                    options.add("all");
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        options.add(player.getName());
                    }
                    return this.filterCompletions(options, args[1]);
                }
                case "toggle": {
                    if (!this.hasPermission(sender, "randomeffects.admin.toggle")) break;
                    return this.filterCompletions(Arrays.asList("timed", "chunk", "notify"), args[1]);
                }
            }
        }
        return completions;
    }

    private List<String> filterCompletions(List<String> options, String input) {
        return options.stream().filter(option -> option.toLowerCase().startsWith(input.toLowerCase())).collect(Collectors.toList());
    }
}

