/*
 * Decompiled with CFR 0.152.
 */
package ru.art3m4ik3.randomEffects.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import ru.art3m4ik3.randomEffects.RandomEffects;

public class ChunkChangeListener
implements Listener {
    private final RandomEffects plugin;
    private final Map<UUID, String> playerChunks;

    public ChunkChangeListener(RandomEffects plugin) {
        this.plugin = plugin;
        this.playerChunks = new HashMap<UUID, String>();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.plugin.getConfigManager().isChunkModeEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        String currentChunk = this.getChunkKey(player);
        String previousChunk = this.playerChunks.get(playerId);
        if (previousChunk == null || !previousChunk.equals(currentChunk)) {
            this.playerChunks.put(playerId, currentChunk);
            this.plugin.getEffectManager().applyRandomEffects(player);
        }
    }

    private String getChunkKey(Player player) {
        return player.getWorld().getName() + ":" + player.getLocation().getChunk().getX() + ":" + player.getLocation().getChunk().getZ();
    }
}

