/*
 * Decompiled with CFR 0.152.
 */
package ru.art3m4ik3.randomEffects.managers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.potion.PotionEffectType;
import ru.art3m4ik3.randomEffects.RandomEffects;

public class ConfigManager {
    private final RandomEffects plugin;
    private FileConfiguration config;
    private File configFile;
    private boolean timedModeEnabled;
    private int timedInterval;
    private boolean chunkModeEnabled;
    private List<PotionEffectType> availableEffects;
    private int minEffectDuration;
    private int maxEffectDuration;
    private int minEffectAmplifier;
    private int maxEffectAmplifier;
    private boolean notifyPlayers;

    public ConfigManager(RandomEffects plugin) {
        this.plugin = plugin;
        this.setupConfig();
        this.loadConfig();
    }

    private void setupConfig() {
        this.plugin.saveDefaultConfig();
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        this.config = this.plugin.getConfig();
        if (!this.configFile.exists()) {
            this.plugin.getLogger().info("Creating default config.yml");
            this.plugin.saveResource("config.yml", false);
        }
    }

    public void loadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.timedModeEnabled = this.config.getBoolean("effects.timed.enabled", true);
        this.timedInterval = this.config.getInt("effects.timed.interval", 60);
        this.chunkModeEnabled = this.config.getBoolean("effects.chunk.enabled", true);
        this.minEffectDuration = this.config.getInt("effects.duration.min", 20);
        this.maxEffectDuration = this.config.getInt("effects.duration.max", 60);
        this.minEffectAmplifier = this.config.getInt("effects.amplifier.min", 0);
        this.maxEffectAmplifier = this.config.getInt("effects.amplifier.max", 2);
        this.notifyPlayers = this.config.getBoolean("effects.notifyPlayers", true);
        this.loadAvailableEffects();
    }

    private void loadAvailableEffects() {
        this.availableEffects = new ArrayList<PotionEffectType>();
        List<String> effectNames = this.config.getStringList("effects.available");
        if (effectNames.isEmpty()) {
            effectNames = this.getDefaultEffects();
            this.config.set("effects.available", effectNames);
            this.saveConfig();
        }
        for (String effectName : effectNames) {
            try {
                PotionEffectType effectType = this.getEffectByName(effectName);
                if (effectType == null) continue;
                this.availableEffects.add(effectType);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Unknown effect type: " + effectName);
            }
        }
        this.plugin.getLogger().info("Loaded " + this.availableEffects.size() + " available effects");
    }

    private PotionEffectType getEffectByName(String name) {
        PotionEffectType type = PotionEffectType.getByName((String)name.toUpperCase());
        if (type != null) {
            return type;
        }
        switch (name.toUpperCase()) {
            case "SLOW": {
                return PotionEffectType.getByName((String)"SLOWNESS");
            }
            case "FAST_DIGGING": {
                return PotionEffectType.getByName((String)"HASTE");
            }
            case "SLOW_DIGGING": {
                return PotionEffectType.getByName((String)"MINING_FATIGUE");
            }
            case "INCREASE_DAMAGE": {
                return PotionEffectType.getByName((String)"STRENGTH");
            }
            case "HEAL": {
                return PotionEffectType.getByName((String)"INSTANT_HEALTH");
            }
            case "HARM": {
                return PotionEffectType.getByName((String)"INSTANT_DAMAGE");
            }
            case "JUMP": {
                return PotionEffectType.getByName((String)"JUMP_BOOST");
            }
            case "CONFUSION": {
                return PotionEffectType.getByName((String)"NAUSEA");
            }
            case "DAMAGE_RESISTANCE": {
                return PotionEffectType.getByName((String)"RESISTANCE");
            }
        }
        return null;
    }

    private List<String> getDefaultEffects() {
        ArrayList<String> defaults = new ArrayList<String>();
        defaults.add("SPEED");
        defaults.add("SLOWNESS");
        defaults.add("HASTE");
        defaults.add("MINING_FATIGUE");
        defaults.add("STRENGTH");
        defaults.add("JUMP_BOOST");
        defaults.add("NAUSEA");
        defaults.add("REGENERATION");
        defaults.add("RESISTANCE");
        defaults.add("FIRE_RESISTANCE");
        defaults.add("WATER_BREATHING");
        defaults.add("INVISIBILITY");
        defaults.add("BLINDNESS");
        defaults.add("NIGHT_VISION");
        defaults.add("HUNGER");
        defaults.add("WEAKNESS");
        defaults.add("POISON");
        defaults.add("WITHER");
        defaults.add("HEALTH_BOOST");
        defaults.add("ABSORPTION");
        defaults.add("GLOWING");
        defaults.add("LEVITATION");
        defaults.add("LUCK");
        defaults.add("UNLUCK");
        return defaults;
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + String.valueOf(this.configFile), e);
        }
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.loadConfig();
    }

    public boolean isTimedModeEnabled() {
        return this.timedModeEnabled;
    }

    public void setTimedModeEnabled(boolean timedModeEnabled) {
        this.timedModeEnabled = timedModeEnabled;
        this.config.set("effects.timed.enabled", (Object)timedModeEnabled);
    }

    public int getTimedInterval() {
        return this.timedInterval;
    }

    public void setTimedInterval(int timedInterval) {
        this.timedInterval = timedInterval;
        this.config.set("effects.timed.interval", (Object)timedInterval);
    }

    public boolean isChunkModeEnabled() {
        return this.chunkModeEnabled;
    }

    public void setChunkModeEnabled(boolean chunkModeEnabled) {
        this.chunkModeEnabled = chunkModeEnabled;
        this.config.set("effects.chunk.enabled", (Object)chunkModeEnabled);
    }

    public List<PotionEffectType> getAvailableEffects() {
        return this.availableEffects;
    }

    public int getMinEffectDuration() {
        return this.minEffectDuration;
    }

    public int getMaxEffectDuration() {
        return this.maxEffectDuration;
    }

    public int getMinEffectAmplifier() {
        return this.minEffectAmplifier;
    }

    public int getMaxEffectAmplifier() {
        return this.maxEffectAmplifier;
    }

    public boolean isNotifyPlayers() {
        return this.notifyPlayers;
    }

    public void setNotifyPlayers(boolean notify) {
        this.notifyPlayers = notify;
        this.config.set("effects.notifyPlayers", (Object)notify);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

