/*
 * Decompiled with CFR 0.152.
 */
package ru.art3m4ik3.randomEffects.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import ru.art3m4ik3.randomEffects.RandomEffects;
import ru.art3m4ik3.randomEffects.managers.ConfigManager;
import ru.art3m4ik3.randomEffects.managers.LanguageManager;

public class EffectManager {
    private final RandomEffects plugin;
    private final Random random;
    private final Map<UUID, List<PotionEffect>> activeEffects;

    public EffectManager(RandomEffects plugin) {
        this.plugin = plugin;
        this.random = new Random();
        this.activeEffects = new HashMap<UUID, List<PotionEffect>>();
    }

    public void applyRandomEffects(Player player) {
        List<PotionEffectType> availableEffects;
        if (player == null || !player.isOnline()) {
            return;
        }
        ConfigManager config = this.plugin.getConfigManager();
        if (config.getConfig().getBoolean("effects.clearPreviousEffects", true)) {
            this.clearEffects(player);
        }
        if ((availableEffects = config.getAvailableEffects()).isEmpty()) {
            this.plugin.getLogger().warning("No available effects configured!");
            return;
        }
        int minEffects = config.getConfig().getInt("effects.count.min", 1);
        int maxEffects = config.getConfig().getInt("effects.count.max", 3);
        minEffects = Math.max(1, minEffects);
        maxEffects = Math.max(minEffects, maxEffects);
        int numEffects = this.random.nextInt(maxEffects - minEffects + 1) + minEffects;
        numEffects = Math.min(numEffects, availableEffects.size());
        List<PotionEffectType> selectedEffects = this.getRandomEffects(availableEffects, numEffects);
        ArrayList<PotionEffect> appliedEffects = new ArrayList<PotionEffect>();
        for (PotionEffectType effectType : selectedEffects) {
            int minDuration = config.getMinEffectDuration();
            int maxDuration = config.getMaxEffectDuration();
            int duration = this.random.nextInt(maxDuration - minDuration + 1) + minDuration;
            int minAmplifier = config.getMinEffectAmplifier();
            int maxAmplifier = config.getMaxEffectAmplifier();
            int amplifier = this.random.nextInt(maxAmplifier - minAmplifier + 1) + minAmplifier;
            PotionEffect effect = new PotionEffect(effectType, duration * 20, amplifier, false, config.getConfig().getBoolean("effects.showParticles", true));
            player.addPotionEffect(effect);
            appliedEffects.add(effect);
        }
        this.activeEffects.put(player.getUniqueId(), appliedEffects);
        if (config.isNotifyPlayers()) {
            this.notifyPlayerOfEffects(player, appliedEffects);
        }
    }

    public void applyRandomEffectsToAll() {
        ConfigManager config = this.plugin.getConfigManager();
        List<PotionEffectType> availableEffects = config.getAvailableEffects();
        if (availableEffects.isEmpty()) {
            this.plugin.getLogger().warning("No available effects configured!");
            return;
        }
        int minEffects = config.getConfig().getInt("effects.count.min", 1);
        int maxEffects = config.getConfig().getInt("effects.count.max", 3);
        minEffects = Math.max(1, minEffects);
        maxEffects = Math.max(minEffects, maxEffects);
        int numEffects = this.random.nextInt(maxEffects - minEffects + 1) + minEffects;
        numEffects = Math.min(numEffects, availableEffects.size());
        List<PotionEffectType> selectedEffects = this.getRandomEffects(availableEffects, numEffects);
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (PotionEffectType effectType : selectedEffects) {
            int minDuration = config.getMinEffectDuration();
            int maxDuration = config.getMaxEffectDuration();
            int duration = this.random.nextInt(maxDuration - minDuration + 1) + minDuration;
            int minAmplifier = config.getMinEffectAmplifier();
            int maxAmplifier = config.getMaxEffectAmplifier();
            int amplifier = this.random.nextInt(maxAmplifier - minAmplifier + 1) + minAmplifier;
            PotionEffect effect = new PotionEffect(effectType, duration * 20, amplifier, false, config.getConfig().getBoolean("effects.showParticles", true));
            effects.add(effect);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (config.getConfig().getBoolean("effects.clearPreviousEffects", true)) {
                this.clearEffects(player);
            }
            for (PotionEffect effect : effects) {
                player.addPotionEffect(effect);
            }
            this.activeEffects.put(player.getUniqueId(), effects);
            if (!config.isNotifyPlayers()) continue;
            this.notifyPlayerOfEffects(player, effects);
        }
    }

    public void clearEffects(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        this.activeEffects.remove(player.getUniqueId());
    }

    private List<PotionEffectType> getRandomEffects(List<PotionEffectType> availableEffects, int count) {
        ArrayList<PotionEffectType> shuffled = new ArrayList<PotionEffectType>(availableEffects);
        Collections.shuffle(shuffled, this.random);
        return shuffled.subList(0, Math.min(count, shuffled.size()));
    }

    private void notifyPlayerOfEffects(Player player, List<PotionEffect> effects) {
        LanguageManager lang = this.plugin.getLanguageManager();
        ArrayList<String> effectNames = new ArrayList<String>();
        for (PotionEffect effect : effects) {
            String effectName = this.formatEffectName(effect.getType().getName(), effect.getAmplifier());
            effectNames.add(effectName);
        }
        String effectList = String.join((CharSequence)", ", effectNames);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("effects", effectList);
        String message = lang.getFormattedMessage("effects.applied", placeholders);
        player.sendMessage(message);
    }

    private String formatEffectName(String name, int amplifier) {
        String effectKey;
        LanguageManager lang = this.plugin.getLanguageManager();
        Object effectName = lang.getMessage(effectKey = "effects.names." + name.toLowerCase());
        if (((String)effectName).startsWith("Missing message:")) {
            effectName = name.replace("_", " ");
            effectName = ((String)effectName).substring(0, 1).toUpperCase() + ((String)effectName).substring(1).toLowerCase();
        }
        String level = this.getRomanNumeralFromAmplifier(amplifier);
        return (String)effectName + " " + level;
    }

    private String getRomanNumeralFromAmplifier(int amplifier) {
        switch (amplifier) {
            case 0: {
                return "I";
            }
            case 1: {
                return "II";
            }
            case 2: {
                return "III";
            }
            case 3: {
                return "IV";
            }
            case 4: {
                return "V";
            }
            case 5: {
                return "VI";
            }
            case 6: {
                return "VII";
            }
            case 7: {
                return "VIII";
            }
            case 8: {
                return "IX";
            }
            case 9: {
                return "X";
            }
        }
        return String.valueOf(amplifier + 1);
    }

    public List<PotionEffect> getActiveEffects(Player player) {
        return this.activeEffects.getOrDefault(player.getUniqueId(), new ArrayList());
    }
}

