/*
 * Decompiled with CFR 0.152.
 */
package ru.art3m4ik3.randomEffects.managers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import ru.art3m4ik3.randomEffects.RandomEffects;

public class LanguageManager {
    private final RandomEffects plugin;
    private FileConfiguration langConfig;
    private File langFile;
    private String currentLanguage;
    private Map<String, String> messageCache;

    public LanguageManager(RandomEffects plugin) {
        this.plugin = plugin;
        this.messageCache = new HashMap<String, String>();
        this.setupLanguage();
    }

    private void setupLanguage() {
        String language;
        this.currentLanguage = language = this.plugin.getConfig().getString("language", "en");
        File langFolder = new File(this.plugin.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        this.langFile = new File(String.valueOf(this.plugin.getDataFolder()) + "/lang", language + ".yml");
        if (!this.langFile.exists()) {
            this.plugin.saveResource("lang/" + language + ".yml", false);
        }
        if (!this.langFile.exists()) {
            this.plugin.getLogger().warning("Language file " + language + ".yml not found. Using English as fallback.");
            this.currentLanguage = language = "en";
            this.langFile = new File(String.valueOf(this.plugin.getDataFolder()) + "/lang", language + ".yml");
            this.plugin.saveResource("lang/" + language + ".yml", false);
        }
        this.loadLanguageFile();
    }

    private void loadLanguageFile() {
        this.langConfig = YamlConfiguration.loadConfiguration((File)this.langFile);
        InputStream defaultLangStream = this.plugin.getResource("lang/" + this.currentLanguage + ".yml");
        if (defaultLangStream != null) {
            YamlConfiguration defaultLang = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultLangStream, StandardCharsets.UTF_8));
            this.langConfig.setDefaults((Configuration)defaultLang);
        }
        this.messageCache.clear();
        for (String key : this.langConfig.getKeys(true)) {
            if (!this.langConfig.isString(key)) continue;
            this.messageCache.put(key, this.langConfig.getString(key));
        }
    }

    public void reloadLanguage() {
        String newLanguage = this.plugin.getConfig().getString("language", "en");
        if (!this.currentLanguage.equals(newLanguage)) {
            this.currentLanguage = newLanguage;
            this.langFile = new File(String.valueOf(this.plugin.getDataFolder()) + "/lang", this.currentLanguage + ".yml");
            if (!this.langFile.exists()) {
                this.plugin.saveResource("lang/" + this.currentLanguage + ".yml", false);
            }
        }
        this.loadLanguageFile();
    }

    public void saveLanguageFile() {
        try {
            this.langConfig.save(this.langFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save language file to " + String.valueOf(this.langFile), e);
        }
    }

    public String getMessage(String key) {
        Object message = this.messageCache.get(key);
        if (message == null) {
            message = this.langConfig.getString(key);
            if (message == null) {
                message = "Missing message: " + key;
                this.plugin.getLogger().warning("Missing message key: " + key);
            } else {
                this.messageCache.put(key, (String)message);
            }
        }
        return message;
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.getMessage(key);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        return message;
    }

    public String getFormattedMessage(String key) {
        return this.getMessage(key).replace("&", "\u00a7");
    }

    public String getFormattedMessage(String key, Map<String, String> placeholders) {
        return this.getMessage(key, placeholders).replace("&", "\u00a7");
    }
}

