/*
 * Decompiled with CFR 0.152.
 */
package chihalu.improvedshield.config;

import chihalu.improvedshield.ImprovedShield;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class ImprovedShieldServerConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "improvedshield-server.json";
    private static ConfigData data = new ConfigData();

    private ImprovedShieldServerConfig() {
    }

    public static void load() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
        if (!Files.exists(path, new LinkOption[0])) {
            ImprovedShieldServerConfig.write(path);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            ConfigData loaded = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            if (loaded != null) {
                data = loaded;
            } else {
                data = new ConfigData();
                ImprovedShieldServerConfig.write(path);
            }
        }
        catch (IOException exception) {
            ImprovedShield.LOGGER.error("Failed to read Improved Shield server config", (Throwable)exception);
        }
    }

    public static boolean allowGameplayFeatures() {
        return ImprovedShieldServerConfig.data.enableGameplayFeatures;
    }

    private static void write(Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                GSON.toJson((Object)data, (Appendable)writer);
            }
        }
        catch (IOException exception) {
            ImprovedShield.LOGGER.error("Failed to write Improved Shield server config", (Throwable)exception);
        }
    }

    private static final class ConfigData {
        boolean enableGameplayFeatures = false;

        private ConfigData() {
        }
    }
}

