/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce;

import java.io.IOException;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.texboobcat.mineCommerce.command.MineCommerceCommand;
import org.texboobcat.mineCommerce.command.RevokeCommand;
import org.texboobcat.mineCommerce.command.StoreCommand;
import org.texboobcat.mineCommerce.config.ConfigManager;
import org.texboobcat.mineCommerce.config.MappingsLoader;
import org.texboobcat.mineCommerce.db.DatabaseManager;
import org.texboobcat.mineCommerce.delivery.DeliveryService;
import org.texboobcat.mineCommerce.delivery.QueuedDeliveryListener;
import org.texboobcat.mineCommerce.integrations.EconomyService;
import org.texboobcat.mineCommerce.integrations.PermissionsService;
import org.texboobcat.mineCommerce.link.LinkService;
import org.texboobcat.mineCommerce.metrics.MetricsService;
import org.texboobcat.mineCommerce.rest.RestServer;
import org.texboobcat.mineCommerce.store.BedrockUIService;
import org.texboobcat.mineCommerce.store.StoreGui;
import org.texboobcat.mineCommerce.store.StoreGuiConfig;
import org.texboobcat.mineCommerce.sync.CommerceSyncService;

public final class MineCommerce
extends JavaPlugin {
    private DatabaseManager databaseManager;
    private MappingsLoader mappingsLoader;
    private LinkService linkService;
    private DeliveryService deliveryService;
    private PermissionsService permissionsService;
    private EconomyService economyService;
    private RestServer restServer;
    private MetricsService metricsService;
    private StoreGuiConfig storeGuiConfig;
    private BedrockUIService bedrockUIService;
    private CommerceSyncService commerceSyncService;

    public void onEnable() {
        boolean hasGeyser;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.saveDefaultConfig();
        ConfigManager.upgradeAndMerge(this);
        try {
            this.databaseManager = new DatabaseManager(this);
            this.databaseManager.init();
            this.getLogger().info("MineCommerce database initialized successfully.");
        }
        catch (SQLException e) {
            this.getLogger().severe("Failed to initialize database: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.mappingsLoader = new MappingsLoader(this);
        this.mappingsLoader.load();
        this.linkService = new LinkService(this, this.databaseManager.getConnection());
        this.deliveryService = new DeliveryService(this);
        this.permissionsService = new PermissionsService(this.getLogger());
        this.economyService = new EconomyService(this.getLogger());
        MineCommerceCommand cmd = new MineCommerceCommand(this);
        if (this.getCommand("minecommerce") != null) {
            this.getCommand("minecommerce").setExecutor((CommandExecutor)cmd);
            this.getCommand("minecommerce").setTabCompleter((TabCompleter)cmd);
        } else {
            this.getLogger().warning("Command 'minecommerce' not defined in plugin.yml");
        }
        this.storeGuiConfig = new StoreGuiConfig(this);
        this.storeGuiConfig.load();
        StoreGui storeGui = new StoreGui(this);
        Bukkit.getPluginManager().registerEvents((Listener)storeGui, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new QueuedDeliveryListener(this), (Plugin)this);
        boolean hasFloodgate = this.getServer().getPluginManager().getPlugin("floodgate") != null;
        boolean bl = hasGeyser = this.getServer().getPluginManager().getPlugin("Geyser-Spigot") != null || this.getServer().getPluginManager().getPlugin("Geyser") != null;
        if (hasFloodgate || hasGeyser) {
            this.bedrockUIService = new BedrockUIService(this);
            if (hasFloodgate) {
                this.getLogger().info("Bedrock support (Floodgate) detected; Bedrock Forms UI enabled.");
            } else {
                this.getLogger().warning("Geyser detected without Floodgate: Bedrock detection enabled via Geyser API, but Forms UI requires Floodgate. Falling back to chat/QR flow.");
            }
        }
        if (this.getCommand("store") != null) {
            this.getCommand("store").setExecutor((CommandExecutor)new StoreCommand(this, storeGui));
        } else {
            this.getLogger().warning("Command 'store' not defined in plugin.yml");
        }
        if (this.getCommand("revoke") != null) {
            RevokeCommand rc = new RevokeCommand(this);
            this.getCommand("revoke").setExecutor((CommandExecutor)rc);
            this.getCommand("revoke").setTabCompleter((TabCompleter)rc);
        } else {
            this.getLogger().warning("Command 'revoke' not defined in plugin.yml");
        }
        this.commerceSyncService = new CommerceSyncService(this);
        this.commerceSyncService.startSchedulerIfEnabled();
        this.metricsService = new MetricsService();
        if (this.getConfig().getBoolean("server.http_enabled", true)) {
            try {
                this.restServer = new RestServer(this);
                this.restServer.start();
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to start REST API: " + e.getMessage());
            }
        }
        this.getLogger().info("MineCommerce enabled.");
    }

    public void onDisable() {
        if (this.commerceSyncService != null) {
            this.commerceSyncService.stopScheduler();
        }
        if (this.restServer != null) {
            this.restServer.stop();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("MineCommerce disabled.");
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public MappingsLoader getMappingsLoader() {
        return this.mappingsLoader;
    }

    public LinkService getLinkService() {
        return this.linkService;
    }

    public DeliveryService getDeliveryService() {
        return this.deliveryService;
    }

    public PermissionsService getPermissionsService() {
        return this.permissionsService;
    }

    public EconomyService getEconomyService() {
        return this.economyService;
    }

    public RestServer getRestServer() {
        return this.restServer;
    }

    public MetricsService getMetricsService() {
        return this.metricsService;
    }

    public StoreGuiConfig getStoreGuiConfig() {
        return this.storeGuiConfig;
    }

    public BedrockUIService getBedrockUIService() {
        return this.bedrockUIService;
    }

    public CommerceSyncService getCommerceSyncService() {
        return this.commerceSyncService;
    }
}

