/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.texboobcat.mineCommerce.MineCommerce;

public class MineCommerceCommand
implements CommandExecutor,
TabCompleter {
    private final MineCommerce plugin;

    public MineCommerceCommand(MineCommerce plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String sub;
        if (args.length == 0) {
            this.help(sender, label);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "link": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can link.");
                    return true;
                }
                Player p = (Player)sender;
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /" + label + " link <code>");
                    return true;
                }
                String code = args[1];
                try {
                    boolean ok = this.plugin.getLinkService().claimCode(p.getUniqueId(), code);
                    if (ok) {
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Linked successfully.");
                    } else {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid or expired code.");
                    }
                }
                catch (SQLException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "An error occurred while linking. Check console.");
                    this.plugin.getLogger().severe("Link error: " + e.getMessage());
                }
                return true;
            }
            case "status": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage is only for players.");
                    return true;
                }
                Player p = (Player)sender;
                try {
                    String cid = this.plugin.getLinkService().getLinkedCustomerId(p.getUniqueId());
                    if (cid == null) {
                        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Not linked.");
                    } else {
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Linked to customer: " + String.valueOf(ChatColor.WHITE) + cid);
                    }
                }
                catch (SQLException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not fetch status.");
                }
                return true;
            }
            case "admin": {
                if (!sender.hasPermission("minecommerce.admin")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "No permission.");
                    return true;
                }
                if (args.length >= 2) {
                    String action;
                    switch (action = args[1].toLowerCase()) {
                        case "reload": {
                            this.plugin.reloadConfig();
                            this.plugin.getMappingsLoader().load();
                            if (this.plugin.getStoreGuiConfig() != null) {
                                this.plugin.getStoreGuiConfig().load();
                            }
                            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "MineCommerce reloaded (config, mappings, GUI).");
                            return true;
                        }
                        case "sync": {
                            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Starting sync in background...");
                            this.plugin.getCommerceSyncService().syncNowAsync(this.plugin.getLogger());
                            return true;
                        }
                        case "logs": {
                            String kind = args.length >= 3 ? args[2].toLowerCase() : "deliveries";
                            int limit = 10;
                            if (args.length >= 4) {
                                try {
                                    limit = Math.max(1, Math.min(100, Integer.parseInt(args[3])));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            this.printLogs(sender, kind, limit);
                            return true;
                        }
                    }
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Admin commands: reload, sync, logs [deliveries|orders] [limit]");
                    return true;
                }
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Admin commands: reload, sync, logs [deliveries|orders] [limit]");
                return true;
            }
        }
        this.help(sender, label);
        return true;
    }

    private void help(CommandSender sender, String label) {
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "MineCommerce" + String.valueOf(ChatColor.GRAY) + " \u2014 Commands");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/" + label + " link <code>" + String.valueOf(ChatColor.GRAY) + " \u2014 Link your store account");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/" + label + " status" + String.valueOf(ChatColor.GRAY) + " \u2014 View link status");
        if (sender.hasPermission("minecommerce.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/" + label + " admin reload" + String.valueOf(ChatColor.GRAY) + " \u2014 Reload config/mappings");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/" + label + " admin sync" + String.valueOf(ChatColor.GRAY) + " \u2014 Sync products/categories from WooCommerce");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/" + label + " admin logs [deliveries|orders] [limit]" + String.valueOf(ChatColor.GRAY) + " \u2014 View recent records");
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> base = new ArrayList<String>(Arrays.asList("link", "status"));
            if (sender.hasPermission("minecommerce.admin")) {
                base.add("admin");
            }
            return this.filter(base, args[0]);
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("admin")) {
            return this.filter(List.of("reload", "sync", "logs"), args[1]);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("logs")) {
            return this.filter(List.of("deliveries", "orders"), args[2]);
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("logs")) {
            return this.filter(List.of("10", "25", "50", "100"), args[3]);
        }
        return List.of();
    }

    private List<String> filter(List<String> opts, String prefix) {
        String p = prefix.toLowerCase();
        ArrayList<String> out = new ArrayList<String>();
        for (String s2 : opts) {
            if (!s2.toLowerCase().startsWith(p)) continue;
            out.add(s2);
        }
        return out;
    }

    private void printLogs(CommandSender sender, String kind, int limit) {
        block29: {
            try {
                Connection c = this.plugin.getDatabaseManager().getConnection();
                if ("orders".equals(kind)) {
                    String sql = "SELECT id, player_uuid, status, created_at, updated_at FROM orders ORDER BY updated_at DESC LIMIT ?";
                    try (PreparedStatement ps = c.prepareStatement(sql);){
                        ps.setInt(1, limit);
                        try (ResultSet rs = ps.executeQuery();){
                            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Orders (" + limit + "):");
                            while (rs.next()) {
                                String id = rs.getString(1);
                                String pu = rs.getString(2);
                                String st = rs.getString(3);
                                long ca = rs.getLong(4);
                                long ua = rs.getLong(5);
                                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "#" + id + String.valueOf(ChatColor.DARK_GRAY) + " | " + String.valueOf(ChatColor.YELLOW) + st + String.valueOf(ChatColor.DARK_GRAY) + " | player=" + (pu == null ? "" : pu) + " | c=" + ca + " u=" + ua);
                            }
                            break block29;
                        }
                    }
                }
                String sql = "SELECT order_id, action, success, message, created_at FROM deliveries ORDER BY created_at DESC LIMIT ?";
                try (PreparedStatement ps = c.prepareStatement(sql);){
                    ps.setInt(1, limit);
                    try (ResultSet rs = ps.executeQuery();){
                        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "Deliveries (" + limit + "):");
                        while (rs.next()) {
                            String oid = rs.getString(1);
                            String act = rs.getString(2);
                            boolean ok = rs.getInt(3) == 1;
                            String msg = rs.getString(4);
                            long ts = rs.getLong(5);
                            sender.sendMessage((ok ? String.valueOf(ChatColor.GREEN) + "OK" : String.valueOf(ChatColor.RED) + "ERR") + String.valueOf(ChatColor.DARK_GRAY) + " | " + String.valueOf(ChatColor.GRAY) + oid + String.valueOf(ChatColor.DARK_GRAY) + " | " + String.valueOf(ChatColor.YELLOW) + act + String.valueOf(ChatColor.DARK_GRAY) + " | " + (msg == null ? "" : msg) + " | t=" + ts);
                        }
                    }
                }
            }
            catch (SQLException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to read logs; see console.");
                this.plugin.getLogger().severe("Log query error: " + e.getMessage());
            }
        }
    }
}

