/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.command;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.texboobcat.mineCommerce.MineCommerce;
import org.texboobcat.mineCommerce.config.MappingsLoader;

public class RevokeCommand
implements CommandExecutor,
TabCompleter {
    private final MineCommerce plugin;

    public RevokeCommand(MineCommerce plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission("minecommerce.revoke") && !sender.hasPermission("minecommerce.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No permission.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /" + label + " <player> <sku> [orderId]");
            return true;
        }
        String target = args[0];
        String sku = args[1];
        String orderId = args.length >= 3 ? args[2] : "manual";
        Player online = Bukkit.getPlayerExact((String)target);
        if (online == null) {
            try {
                UUID u = UUID.fromString(target);
                online = Bukkit.getPlayer((UUID)u);
            }
            catch (IllegalArgumentException u) {
                // empty catch block
            }
        }
        if (online != null) {
            boolean any = this.plugin.getDeliveryService().revokeSkuFromPlayer(online, sku, orderId);
            if (any) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Revocation executed for " + online.getName() + " sku=" + sku);
            } else {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "No revocable actions found for sku=" + sku + ". Check mappings.");
            }
            return true;
        }
        OfflinePlayer offline = null;
        try {
            UUID u = UUID.fromString(target);
            offline = Bukkit.getOfflinePlayer((UUID)u);
        }
        catch (IllegalArgumentException e) {
            offline = Bukkit.getOfflinePlayer((String)target);
        }
        if (offline == null || offline.getUniqueId() == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown player: " + target);
            return true;
        }
        boolean any = this.plugin.getDeliveryService().revokeSkuFromOffline(offline, sku, orderId);
        if (any) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Revocation executed for offline player " + String.valueOf(offline.getName() == null ? offline.getUniqueId() : offline.getName()) + " sku=" + sku);
        } else {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "No revocable actions found for sku=" + sku + ". Check mappings.");
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (!sender.hasPermission("minecommerce.revoke") && !sender.hasPermission("minecommerce.admin")) {
            return List.of();
        }
        if (args.length == 1) {
            ArrayList<String> names = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                names.add(p.getName());
            }
            return this.filter(names, args[0]);
        }
        if (args.length == 2) {
            MappingsLoader mappings = this.plugin.getMappingsLoader();
            ArrayList<String> skus = new ArrayList<String>();
            for (MappingsLoader.ProductMapping pm : mappings.getAll()) {
                skus.add(pm.sku);
            }
            return this.filter(skus, args[1]);
        }
        return List.of();
    }

    private List<String> filter(List<String> opts, String prefix) {
        String p = prefix.toLowerCase();
        ArrayList<String> out = new ArrayList<String>();
        for (String s2 : opts) {
            if (!s2.toLowerCase().startsWith(p)) continue;
            out.add(s2);
        }
        return out;
    }
}

