/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.command;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.texboobcat.mineCommerce.MineCommerce;
import org.texboobcat.mineCommerce.store.BedrockUIService;
import org.texboobcat.mineCommerce.store.StoreGui;

public class StoreCommand
implements CommandExecutor {
    private final MineCommerce plugin;
    private final StoreGui storeGui;

    public StoreCommand(MineCommerce plugin, StoreGui storeGui) {
        this.plugin = plugin;
        this.storeGui = storeGui;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player && !sender.hasPermission("minecommerce.store")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        String url = this.plugin.getConfig().getString("server.store_url", "https://example.com/store");
        Component msg = Component.text((String)"Visit our store: ", (TextColor)NamedTextColor.AQUA).append(((TextComponent)Component.text((String)url, (TextColor)NamedTextColor.BLUE, (TextDecoration[])new TextDecoration[]{TextDecoration.UNDERLINED}).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Open in browser")))).clickEvent(ClickEvent.openUrl((String)url)));
        sender.sendMessage(msg);
        if (sender instanceof Player) {
            Player p = (Player)sender;
            BedrockUIService bedrock = this.plugin.getBedrockUIService();
            if (bedrock != null && bedrock.isBedrock(p)) {
                bedrock.open(p);
            } else {
                this.storeGui.open(p);
            }
        }
        return true;
    }
}

