/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class ConfigManager {
    private static final String KEY_VERSION = "config_version";

    private ConfigManager() {
    }

    public static void upgradeAndMerge(JavaPlugin plugin) {
        try {
            File configFile = new File(plugin.getDataFolder(), "config.yml");
            if (!configFile.exists()) {
                return;
            }
            YamlConfiguration current = YamlConfiguration.loadConfiguration((File)configFile);
            FileConfiguration defaults = ConfigManager.loadDefaults(plugin, "config.yml");
            if (defaults == null) {
                return;
            }
            int curVer = current.getInt(KEY_VERSION, 0);
            int defVer = defaults.getInt(KEY_VERSION, 0);
            boolean changed = false;
            if (defVer > curVer) {
                changed |= ConfigManager.runMigrations(plugin, (FileConfiguration)current, curVer, defVer);
                current.set(KEY_VERSION, (Object)defVer);
                changed = true;
            }
            if (changed |= ConfigManager.mergeMissing((FileConfiguration)current, defaults, "")) {
                ConfigManager.backupConfig(configFile);
                current.save(configFile);
                plugin.reloadConfig();
                plugin.getLogger().info("Config updated to version " + current.getInt(KEY_VERSION, 0) + " and merged with new defaults.");
            }
        }
        catch (Exception e) {
            plugin.getLogger().warning("Config auto-update failed: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static FileConfiguration loadDefaults(JavaPlugin plugin, String resource) {
        try (InputStream in = plugin.getResource(resource);){
            YamlConfiguration yamlConfiguration;
            if (in == null) {
                FileConfiguration fileConfiguration = null;
                return fileConfiguration;
            }
            try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
            }
            return yamlConfiguration;
        }
        catch (IOException e) {
            plugin.getLogger().warning("Failed to read default config: " + e.getMessage());
            return null;
        }
    }

    private static boolean mergeMissing(FileConfiguration target, FileConfiguration defaults, String pathPrefix) {
        boolean changed = false;
        Set keys = defaults.getKeys(false);
        for (String key : keys) {
            Object path = pathPrefix.isEmpty() ? key : pathPrefix + "." + key;
            Object defVal = defaults.get((String)path);
            if (defVal instanceof ConfigurationSection) {
                if (!target.isConfigurationSection((String)path)) {
                    target.createSection((String)path);
                    changed = true;
                }
                FileConfiguration defSub = ConfigManager.sectionAsConfig((ConfigurationSection)defVal);
                FileConfiguration tgtSub = ConfigManager.sectionAsConfig(target.getConfigurationSection((String)path));
                changed |= ConfigManager.mergeMissing(tgtSub, defSub, "");
                for (String subKey : tgtSub.getKeys(true)) {
                    target.set((String)path + (String)(subKey.isEmpty() ? "" : "." + subKey), tgtSub.get(subKey));
                }
                continue;
            }
            if (target.contains((String)path)) continue;
            target.set((String)path, defVal);
            changed = true;
        }
        return changed;
    }

    private static FileConfiguration sectionAsConfig(ConfigurationSection section) {
        YamlConfiguration cfg = new YamlConfiguration();
        for (String k : section.getKeys(true)) {
            cfg.set(k, section.get(k));
        }
        return cfg;
    }

    private static void backupConfig(File file) {
        try {
            if (!file.exists()) {
                return;
            }
            File backup = new File(file.getParentFile(), file.getName() + ".bak." + Instant.now().toEpochMilli());
            Files.copy(file.toPath(), backup.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean runMigrations(JavaPlugin plugin, FileConfiguration cfg, int fromVer, int toVer) {
        boolean changed = false;
        block4: for (int v = fromVer + 1; v <= toVer; ++v) {
            switch (v) {
                case 1: {
                    if (cfg.isInt(KEY_VERSION)) continue block4;
                    cfg.set(KEY_VERSION, (Object)1);
                    changed = true;
                    continue block4;
                }
                case 2: {
                    continue block4;
                }
            }
        }
        return changed;
    }
}

