/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MappingsLoader {
    private final JavaPlugin plugin;
    private Map<String, ProductMapping> products = new HashMap<String, ProductMapping>();
    private Map<String, Category> categories = new HashMap<String, Category>();

    public MappingsLoader(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void load() {
        YamlConfiguration cfg;
        File mappingsFile = new File(this.plugin.getDataFolder(), "mappings.yml");
        if (!mappingsFile.exists()) {
            this.plugin.saveResource("mappings.yml", false);
        }
        Map prod = (cfg = YamlConfiguration.loadConfiguration((File)mappingsFile)).getConfigurationSection("products") != null ? cfg.getConfigurationSection("products").getValues(false) : Collections.emptyMap();
        HashMap<String, ProductMapping> out = new HashMap<String, ProductMapping>();
        for (Map.Entry e : prod.entrySet()) {
            String sku = (String)e.getKey();
            String name = cfg.getString("products." + sku + ".name", sku);
            String icon = cfg.getString("products." + sku + ".icon", null);
            String description = cfg.getString("products." + sku + ".description", null);
            double price = cfg.getDouble("products." + sku + ".price", -1.0);
            String urlOverride = cfg.getString("products." + sku + ".url", null);
            String productId = cfg.getString("products." + sku + ".product_id", null);
            String variantId = cfg.getString("products." + sku + ".variant_id", null);
            String image = cfg.getString("products." + sku + ".image", null);
            List actions = cfg.getMapList("products." + sku + ".actions");
            ArrayList<Action> parsed = new ArrayList<Action>();
            for (Map a : actions) {
                Object am;
                Number num;
                String type = String.valueOf(a.get("type"));
                if ("command".equalsIgnoreCase(type)) {
                    String command = String.valueOf(a.get("command"));
                    parsed.add(Action.command(command));
                    continue;
                }
                if ("permission_group".equalsIgnoreCase(type)) {
                    String group = String.valueOf(a.get("group"));
                    int durationDays = 0;
                    Object dd = a.get("duration_days");
                    if (dd instanceof Number) {
                        num = (Number)dd;
                        durationDays = num.intValue();
                    }
                    parsed.add(Action.permissionGroup(group, durationDays));
                    continue;
                }
                if ("currency".equalsIgnoreCase(type)) {
                    double amount = 0.0;
                    am = a.get("amount");
                    if (am instanceof Number) {
                        num = (Number)am;
                        amount = num.doubleValue();
                    }
                    parsed.add(Action.currency(amount));
                    continue;
                }
                if (!"item".equalsIgnoreCase(type)) continue;
                String material = a.get("material") != null ? String.valueOf(a.get("material")) : "PAPER";
                int amount = 1;
                am = a.get("amount");
                if (am instanceof Number) {
                    num = (Number)am;
                    amount = num.intValue();
                }
                String displayName = a.get("name") != null ? String.valueOf(a.get("name")) : null;
                Object loreObj = a.get("lore");
                ArrayList<String> lore = new ArrayList<String>();
                if (loreObj instanceof List) {
                    List lo = (List)loreObj;
                    for (Object o : lo) {
                        lore.add(String.valueOf(o));
                    }
                }
                HashMap<String, Integer> ench = new HashMap<String, Integer>();
                Object enchObj = a.get("enchantments");
                if (enchObj instanceof Map) {
                    Map m4 = (Map)enchObj;
                    for (Map.Entry en : m4.entrySet()) {
                        String k = String.valueOf(en.getKey());
                        int v = 1;
                        Object vo = en.getValue();
                        if (vo instanceof Number) {
                            Number n = (Number)vo;
                            v = n.intValue();
                        }
                        ench.put(k, v);
                    }
                }
                HashMap<String, String> pdc = new HashMap<String, String>();
                Object pdcObj = a.get("pdc");
                if (pdcObj instanceof Map) {
                    Map m5 = (Map)pdcObj;
                    for (Map.Entry en : m5.entrySet()) {
                        pdc.put(String.valueOf(en.getKey()), String.valueOf(en.getValue()));
                    }
                }
                parsed.add(Action.item(material, amount, displayName, lore, ench, pdc));
            }
            out.put(sku, new ProductMapping(sku, name, parsed, icon, description, price, urlOverride, productId, variantId, image));
        }
        this.products = out;
        this.categories = new HashMap<String, Category>();
        if (cfg.getConfigurationSection("categories") != null) {
            for (String key : cfg.getConfigurationSection("categories").getKeys(false)) {
                String name = cfg.getString("categories." + key + ".name", key);
                String icon = cfg.getString("categories." + key + ".icon", "CHEST");
                String description = cfg.getString("categories." + key + ".description", null);
                String image = cfg.getString("categories." + key + ".image", null);
                List skus = cfg.getStringList("categories." + key + ".skus");
                this.categories.put(key, new Category(key, name, icon, description, image, skus));
            }
        }
        this.plugin.getLogger().info("Loaded " + this.products.size() + " product mappings.");
    }

    public Optional<ProductMapping> getProduct(String sku) {
        return Optional.ofNullable(this.products.get(sku));
    }

    public Collection<ProductMapping> getAll() {
        return this.products.values();
    }

    public Map<String, Category> getCategories() {
        return this.categories;
    }

    public List<ProductMapping> getProductsForCategory(String categoryKey) {
        Category cat = this.categories.get(categoryKey);
        if (cat == null) {
            return new ArrayList<ProductMapping>(this.products.values());
        }
        ArrayList<ProductMapping> list = new ArrayList<ProductMapping>();
        for (String sku : cat.skus) {
            ProductMapping pm = this.products.get(sku);
            if (pm == null) continue;
            list.add(pm);
        }
        return list;
    }

    public static class Action {
        public final Type type;
        public final String command;
        public final String group;
        public final int durationDays;
        public final double amount;
        public final String material;
        public final int itemAmount;
        public final String displayName;
        public final List<String> lore;
        public final Map<String, Integer> enchantments;
        public final Map<String, String> pdc;

        private Action(Type type, String command, String group, int durationDays, double amount, String material, int itemAmount, String displayName, List<String> lore, Map<String, Integer> enchantments, Map<String, String> pdc) {
            this.type = type;
            this.command = command;
            this.group = group;
            this.durationDays = durationDays;
            this.amount = amount;
            this.material = material;
            this.itemAmount = itemAmount;
            this.displayName = displayName;
            this.lore = lore;
            this.enchantments = enchantments;
            this.pdc = pdc;
        }

        public static Action command(String cmd) {
            return new Action(Type.COMMAND, cmd, null, 0, 0.0, null, 0, null, null, null, null);
        }

        public static Action permissionGroup(String group, int durationDays) {
            return new Action(Type.PERMISSION_GROUP, null, group, durationDays, 0.0, null, 0, null, null, null, null);
        }

        public static Action currency(double amount) {
            return new Action(Type.CURRENCY, null, null, 0, amount, null, 0, null, null, null, null);
        }

        public static Action item(String material, int amount, String name, List<String> lore, Map<String, Integer> ench, Map<String, String> pdc) {
            return new Action(Type.ITEM, null, null, 0, 0.0, material, amount, name, lore != null ? lore : new ArrayList<String>(), ench != null ? ench : new HashMap<String, Integer>(), pdc != null ? pdc : new HashMap());
        }

        public static enum Type {
            COMMAND,
            PERMISSION_GROUP,
            CURRENCY,
            ITEM;

        }
    }

    public static class ProductMapping {
        public final String sku;
        public final String name;
        public final List<Action> actions;
        public final String icon;
        public final String description;
        public final double price;
        public final String urlOverride;
        public final String productId;
        public final String variantId;
        public final String image;

        public ProductMapping(String sku, String name, List<Action> actions, String icon, String description, double price, String urlOverride, String productId, String variantId, String image) {
            this.sku = sku;
            this.name = name;
            this.actions = actions;
            this.icon = icon;
            this.description = description;
            this.price = price;
            this.urlOverride = urlOverride;
            this.productId = productId;
            this.variantId = variantId;
            this.image = image;
        }
    }

    public static class Category {
        public final String key;
        public final String name;
        public final String icon;
        public final String description;
        public final String image;
        public final List<String> skus;

        public Category(String key, String name, String icon, String description, String image, List<String> skus) {
            this.key = key;
            this.name = name;
            this.icon = icon;
            this.description = description;
            this.image = image;
            this.skus = skus;
        }
    }
}

