/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager {
    private final JavaPlugin plugin;
    private final Logger logger;
    private Connection connection;

    public DatabaseManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    private void runAutoMigrationIfConfigured(String targetType) {
        try {
            boolean enabled = this.plugin.getConfig().getBoolean("database.auto_migrate.enabled", false);
            String from = this.plugin.getConfig().getString("database.auto_migrate.from", "").toLowerCase();
            if (!enabled || !targetType.equalsIgnoreCase("mysql") && !targetType.equalsIgnoreCase("postgres") && !targetType.equalsIgnoreCase("postgresql")) {
                return;
            }
            if (!from.equals("sqlite")) {
                return;
            }
            String configured = this.plugin.getConfig().getString("database.auto_migrate.sqlite_path", this.plugin.getConfig().getString("database.sqlite.path", "minecommerce.db"));
            File dbFile = new File(configured);
            if (!dbFile.isAbsolute()) {
                dbFile = new File(this.plugin.getDataFolder(), configured);
            }
            if (!dbFile.exists()) {
                this.logger.warning("Auto-migrate enabled but sqlite source not found: " + dbFile.getAbsolutePath());
                return;
            }
            if (!this.isTargetEmpty(this.connection)) {
                this.logger.info("Auto-migrate: target database not empty; skipping migration.");
                return;
            }
            this.logger.info("Auto-migrate: importing data from SQLite " + dbFile.getAbsolutePath());
            String jdbcUrl = "jdbc:sqlite:" + dbFile.getAbsolutePath();
            try {
                Class.forName("org.sqlite.JDBC");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try (Connection src = DriverManager.getConnection(jdbcUrl);){
                src.setAutoCommit(false);
                this.copyAllTables(src, this.connection);
                this.connection.commit();
                this.logger.info("Auto-migrate: migration completed.");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Auto-migrate failed", e);
            try {
                this.connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean isTargetEmpty(Connection dst) throws SQLException {
        return this.count(dst, "players") == 0L && this.count(dst, "orders") == 0L && this.count(dst, "deliveries") == 0L && this.count(dst, "link_codes") == 0L;
    }

    private long count(Connection c, String table) throws SQLException {
        try (Statement st = c.createStatement();){
            long l;
            block12: {
                ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM " + table);
                try {
                    long l2 = l = rs.next() ? rs.getLong(1) : 0L;
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return l;
        }
    }

    private void copyAllTables(Connection src, Connection dst) throws SQLException {
        this.copyPlayers(src, dst);
        this.copyOrders(src, dst);
        this.copyDeliveries(src, dst);
        this.copyLinkCodes(src, dst);
    }

    public void init() throws SQLException {
        String type = this.plugin.getConfig().getString("database.type", "sqlite");
        switch (type.toLowerCase()) {
            case "sqlite": {
                this.connectSqlite();
                break;
            }
            case "mysql": {
                this.connectMySql();
                break;
            }
            case "postgres": 
            case "postgresql": {
                this.connectPostgres();
                break;
            }
            default: {
                this.logger.warning("Unknown database.type '" + type + "', defaulting to sqlite");
                this.connectSqlite();
            }
        }
        this.migrate();
        this.runAutoMigrationIfConfigured(type);
    }

    private void applyPragmas() {
        try (Statement st = this.connection.createStatement();){
            st.execute("PRAGMA journal_mode=WAL");
            st.execute("PRAGMA synchronous=NORMAL");
        }
        catch (SQLException e) {
            this.logger.log(Level.WARNING, "Failed to apply SQLite pragmas", e);
        }
    }

    private void connectSqlite() throws SQLException {
        File parent;
        String configured = this.plugin.getConfig().getString("database.sqlite.path", "minecommerce.db");
        File dbFile = new File(configured);
        if (!dbFile.isAbsolute()) {
            dbFile = new File(this.plugin.getDataFolder(), configured);
        }
        if ((parent = dbFile.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
        String jdbcUrl = "jdbc:sqlite:" + dbFile.getAbsolutePath();
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.logger.info("Connecting to SQLite at " + dbFile.getAbsolutePath());
        this.connection = DriverManager.getConnection(jdbcUrl);
        this.connection.setAutoCommit(true);
        this.applyPragmas();
        this.connection.setAutoCommit(false);
    }

    private void connectMySql() throws SQLException {
        String host = this.plugin.getConfig().getString("database.mysql.host", "127.0.0.1");
        int port = this.plugin.getConfig().getInt("database.mysql.port", 3306);
        String db = this.plugin.getConfig().getString("database.mysql.database", "minecommerce");
        String user = this.plugin.getConfig().getString("database.mysql.user", "minecommerce");
        String pass = this.plugin.getConfig().getString("database.mysql.password", "");
        boolean ssl = this.plugin.getConfig().getBoolean("database.mysql.ssl", true);
        String jdbcUrl = String.format("jdbc:mysql://%s:%d/%s?useSSL=%s&serverTimezone=UTC", host, port, db, ssl);
        this.logger.info("Connecting to MySQL at " + host + ":" + port + "/" + db);
        this.connection = DriverManager.getConnection(jdbcUrl, user, pass);
        this.connection.setAutoCommit(false);
    }

    private void connectPostgres() throws SQLException {
        String host = this.plugin.getConfig().getString("database.postgres.host", "127.0.0.1");
        int port = this.plugin.getConfig().getInt("database.postgres.port", 5432);
        String db = this.plugin.getConfig().getString("database.postgres.database", "minecommerce");
        String user = this.plugin.getConfig().getString("database.postgres.user", "minecommerce");
        String pass = this.plugin.getConfig().getString("database.postgres.password", "");
        boolean ssl = this.plugin.getConfig().getBoolean("database.postgres.ssl", true);
        String jdbcUrl = String.format("jdbc:postgresql://%s:%d/%s?ssl=%s", host, port, db, ssl);
        this.logger.info("Connecting to Postgres at " + host + ":" + port + "/" + db);
        this.connection = DriverManager.getConnection(jdbcUrl, user, pass);
        this.connection.setAutoCommit(false);
    }

    private void migrate() throws SQLException {
        String createPlayers = "CREATE TABLE IF NOT EXISTS players (uuid VARCHAR(36) PRIMARY KEY, customer_id VARCHAR(128), created_at BIGINT NOT NULL)";
        String createOrders = "CREATE TABLE IF NOT EXISTS orders (id VARCHAR(64) PRIMARY KEY, player_uuid VARCHAR(36), status VARCHAR(32) NOT NULL, idempotency_key VARCHAR(128) UNIQUE, payload TEXT, created_at BIGINT NOT NULL, updated_at BIGINT NOT NULL)";
        String createDeliveries = "CREATE TABLE IF NOT EXISTS deliveries (id VARCHAR(64) PRIMARY KEY, order_id VARCHAR(64) NOT NULL, action VARCHAR(64) NOT NULL, success INTEGER NOT NULL, message TEXT, created_at BIGINT NOT NULL)";
        String createLinkCodes = "CREATE TABLE IF NOT EXISTS link_codes (code_hash VARCHAR(64) PRIMARY KEY, customer_id VARCHAR(128), uuid VARCHAR(36), expires_at BIGINT NOT NULL, created_at BIGINT NOT NULL)";
        try (Statement st = this.connection.createStatement();){
            st.execute(createPlayers);
            st.execute(createOrders);
            st.execute(createDeliveries);
            st.execute(createLinkCodes);
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
    }

    private void copyPlayers(Connection src, Connection dst) throws SQLException {
        try (Statement st = src.createStatement();
             ResultSet rs = st.executeQuery("SELECT uuid, customer_id, created_at FROM players");
             PreparedStatement ins = dst.prepareStatement("INSERT INTO players (uuid, customer_id, created_at) VALUES (?,?,?)");){
            while (rs.next()) {
                ins.setString(1, rs.getString(1));
                ins.setString(2, rs.getString(2));
                ins.setLong(3, rs.getLong(3));
                try {
                    ins.executeUpdate();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void copyOrders(Connection src, Connection dst) throws SQLException {
        String sql = "INSERT INTO orders (id, player_uuid, status, idempotency_key, payload, created_at, updated_at) VALUES (?,?,?,?,?,?,?)";
        try (Statement st = src.createStatement();
             ResultSet rs = st.executeQuery("SELECT id, player_uuid, status, idempotency_key, payload, created_at, updated_at FROM orders");
             PreparedStatement ins = dst.prepareStatement(sql);){
            while (rs.next()) {
                ins.setString(1, rs.getString(1));
                ins.setString(2, rs.getString(2));
                ins.setString(3, rs.getString(3));
                ins.setString(4, rs.getString(4));
                ins.setString(5, rs.getString(5));
                ins.setLong(6, rs.getLong(6));
                ins.setLong(7, rs.getLong(7));
                try {
                    ins.executeUpdate();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void copyDeliveries(Connection src, Connection dst) throws SQLException {
        String sql = "INSERT INTO deliveries (id, order_id, action, success, message, created_at) VALUES (?,?,?,?,?,?)";
        try (Statement st = src.createStatement();
             ResultSet rs = st.executeQuery("SELECT id, order_id, action, success, message, created_at FROM deliveries");
             PreparedStatement ins = dst.prepareStatement(sql);){
            while (rs.next()) {
                ins.setString(1, rs.getString(1));
                ins.setString(2, rs.getString(2));
                ins.setString(3, rs.getString(3));
                ins.setInt(4, rs.getInt(4));
                ins.setString(5, rs.getString(5));
                ins.setLong(6, rs.getLong(6));
                try {
                    ins.executeUpdate();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private void copyLinkCodes(Connection src, Connection dst) throws SQLException {
        String sql = "INSERT INTO link_codes (code_hash, customer_id, uuid, expires_at, created_at) VALUES (?,?,?,?,?)";
        try (Statement st = src.createStatement();
             ResultSet rs = st.executeQuery("SELECT code_hash, customer_id, uuid, expires_at, created_at FROM link_codes");
             PreparedStatement ins = dst.prepareStatement(sql);){
            while (rs.next()) {
                ins.setString(1, rs.getString(1));
                ins.setString(2, rs.getString(2));
                ins.setString(3, rs.getString(3));
                ins.setLong(4, rs.getLong(4));
                ins.setLong(5, rs.getLong(5));
                try {
                    ins.executeUpdate();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, "Error closing DB connection", e);
            }
        }
    }
}

