/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.delivery;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.texboobcat.mineCommerce.MineCommerce;
import org.texboobcat.mineCommerce.config.MappingsLoader;
import org.texboobcat.mineCommerce.integrations.EconomyService;
import org.texboobcat.mineCommerce.integrations.PermissionsService;

public class DeliveryService {
    private final JavaPlugin plugin;

    public DeliveryService(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean deliverSkuToPlayer(Player player, String sku, String orderId) {
        JavaPlugin javaPlugin = this.plugin;
        if (!(javaPlugin instanceof MineCommerce)) {
            return false;
        }
        MineCommerce mc = (MineCommerce)javaPlugin;
        MappingsLoader mappings = mc.getMappingsLoader();
        PermissionsService perms = mc.getPermissionsService();
        EconomyService economy = mc.getEconomyService();
        Optional<MappingsLoader.ProductMapping> opt = mappings.getProduct(sku);
        if (opt.isEmpty()) {
            return false;
        }
        MappingsLoader.ProductMapping product = opt.get();
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("player", player.getName());
        ctx.put("uuid", player.getUniqueId().toString());
        ctx.put("order_id", orderId == null ? "" : orderId);
        for (MappingsLoader.Action action : product.actions) {
            switch (action.type) {
                case COMMAND: {
                    this.executeCommand(DeliveryService.applyPlaceholders(action.command, ctx));
                    break;
                }
                case PERMISSION_GROUP: {
                    boolean ok;
                    if (perms != null && perms.isAvailable()) {
                        ok = perms.addGroup(player.getUniqueId(), action.group, action.durationDays);
                        this.logDelivery(mc, orderId, "permission_group:" + action.group, ok, ok ? null : "perm grant failed");
                        break;
                    }
                    this.plugin.getLogger().warning("Permission action skipped (LuckPerms not available)");
                    this.logDelivery(mc, orderId, "permission_group:" + action.group, false, "LuckPerms not available");
                    break;
                }
                case CURRENCY: {
                    boolean ok;
                    if (economy != null && economy.isAvailable()) {
                        ok = economy.deposit((OfflinePlayer)player, action.amount);
                        this.logDelivery(mc, orderId, "currency:+" + action.amount, ok, ok ? null : "deposit failed");
                        break;
                    }
                    this.plugin.getLogger().warning("Currency action skipped (Vault economy not available)");
                    this.logDelivery(mc, orderId, "currency:+" + action.amount, false, "Vault economy not available");
                    break;
                }
                case ITEM: {
                    boolean ok = this.giveItemToPlayer(mc, player, action);
                    this.logDelivery(mc, orderId, "item:" + DeliveryService.safe(action.material) + "x" + action.itemAmount, ok, ok ? null : "item give failed");
                    break;
                }
            }
        }
        return true;
    }

    public boolean revokeSkuFromPlayer(Player player, String sku, String orderId) {
        JavaPlugin javaPlugin = this.plugin;
        if (!(javaPlugin instanceof MineCommerce)) {
            return false;
        }
        MineCommerce mc = (MineCommerce)javaPlugin;
        MappingsLoader mappings = mc.getMappingsLoader();
        PermissionsService perms = mc.getPermissionsService();
        EconomyService economy = mc.getEconomyService();
        Optional<MappingsLoader.ProductMapping> opt = mappings.getProduct(sku);
        if (opt.isEmpty()) {
            return false;
        }
        MappingsLoader.ProductMapping product = opt.get();
        boolean any = false;
        for (MappingsLoader.Action action : product.actions) {
            switch (action.type) {
                case PERMISSION_GROUP: {
                    boolean ok;
                    if (perms != null && perms.isAvailable()) {
                        ok = perms.removeGroup(player.getUniqueId(), action.group);
                        this.logDelivery(mc, orderId, "revoke_permission_group:" + action.group, ok, ok ? null : "perm revoke failed");
                        any = true;
                        break;
                    }
                    this.logDelivery(mc, orderId, "revoke_permission_group:" + action.group, false, "LuckPerms not available");
                    break;
                }
                case CURRENCY: {
                    boolean ok;
                    if (economy != null && economy.isAvailable() && action.amount > 0.0) {
                        ok = economy.withdraw((OfflinePlayer)player, action.amount);
                        this.logDelivery(mc, orderId, "currency:-" + action.amount, ok, ok ? null : "withdraw failed");
                        any = true;
                        break;
                    }
                    this.logDelivery(mc, orderId, "currency:-" + action.amount, false, "Vault economy not available");
                    break;
                }
                case COMMAND: {
                    break;
                }
            }
        }
        return any;
    }

    public boolean revokeSkuFromOffline(OfflinePlayer player, String sku, String orderId) {
        JavaPlugin javaPlugin = this.plugin;
        if (!(javaPlugin instanceof MineCommerce)) {
            return false;
        }
        MineCommerce mc = (MineCommerce)javaPlugin;
        MappingsLoader mappings = mc.getMappingsLoader();
        PermissionsService perms = mc.getPermissionsService();
        EconomyService economy = mc.getEconomyService();
        Optional<MappingsLoader.ProductMapping> opt = mappings.getProduct(sku);
        if (opt.isEmpty()) {
            return false;
        }
        MappingsLoader.ProductMapping product = opt.get();
        boolean any = false;
        for (MappingsLoader.Action action : product.actions) {
            switch (action.type) {
                case PERMISSION_GROUP: {
                    boolean ok;
                    if (perms != null && perms.isAvailable()) {
                        ok = perms.removeGroup(player.getUniqueId(), action.group);
                        this.logDelivery(mc, orderId, "revoke_permission_group:" + action.group, ok, ok ? null : "perm revoke failed");
                        any = true;
                        break;
                    }
                    this.logDelivery(mc, orderId, "revoke_permission_group:" + action.group, false, "LuckPerms not available");
                    break;
                }
                case CURRENCY: {
                    boolean ok;
                    if (economy != null && economy.isAvailable() && action.amount > 0.0) {
                        ok = economy.withdraw(player, action.amount);
                        this.logDelivery(mc, orderId, "currency:-" + action.amount, ok, ok ? null : "withdraw failed");
                        any = true;
                        break;
                    }
                    this.logDelivery(mc, orderId, "currency:-" + action.amount, false, "Vault economy not available");
                    break;
                }
                case COMMAND: {
                    break;
                }
            }
        }
        return any;
    }

    private boolean giveItemToPlayer(MineCommerce mc, Player player, MappingsLoader.Action action) {
        try {
            HashMap notFit;
            Material mat = DeliveryService.parseMaterialOrDefault(action.material, Material.PAPER);
            int amount = Math.max(1, action.itemAmount);
            ItemStack item = new ItemStack(mat, amount);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                if (action.displayName != null && !action.displayName.isBlank()) {
                    meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)action.displayName));
                }
                if (action.lore != null && !action.lore.isEmpty()) {
                    ArrayList lore = new ArrayList();
                    for (String string : action.lore) {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
                    }
                    meta.setLore((List)lore);
                }
                if (action.enchantments != null) {
                    for (Map.Entry entry : action.enchantments.entrySet()) {
                        Enchantment enchantment = Enchantment.getByName((String)((String)entry.getKey()).toUpperCase());
                        if (enchantment == null) continue;
                        try {
                            meta.addEnchant(enchantment, Math.max(1, (Integer)entry.getValue()), true);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (action.pdc != null && !action.pdc.isEmpty()) {
                    PersistentDataContainer pdc = meta.getPersistentDataContainer();
                    for (Map.Entry<String, String> entry : action.pdc.entrySet()) {
                        NamespacedKey key = new NamespacedKey((Plugin)mc, DeliveryService.sanitizeKey(entry.getKey()));
                        pdc.set(key, PersistentDataType.STRING, (Object)entry.getValue());
                    }
                }
                item.setItemMeta(meta);
            }
            if (!(notFit = player.getInventory().addItem(new ItemStack[]{item})).isEmpty()) {
                for (ItemStack itemStack : notFit.values()) {
                    player.getWorld().dropItemNaturally(player.getLocation(), itemStack);
                }
            }
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to give item: " + e.getMessage());
            return false;
        }
    }

    private static String sanitizeKey(String key) {
        return key.toLowerCase().replaceAll("[^a-z0-9_.-]+", "_");
    }

    private static Material parseMaterialOrDefault(String s2, Material def) {
        try {
            return Material.valueOf((String)s2.toUpperCase());
        }
        catch (Exception e) {
            return def;
        }
    }

    private static String safe(String s2) {
        return s2 == null ? "" : s2;
    }

    private void logDelivery(MineCommerce mc, String orderId, String action, boolean success, String message) {
        try {
            Connection c = mc.getDatabaseManager().getConnection();
            try (PreparedStatement ps = c.prepareStatement("INSERT INTO deliveries (id, order_id, action, success, message, created_at) VALUES (?,?,?,?,?,?)");){
                ps.setString(1, UUID.randomUUID().toString());
                ps.setString(2, orderId == null ? "" : orderId);
                ps.setString(3, action);
                ps.setInt(4, success ? 1 : 0);
                ps.setString(5, message);
                ps.setLong(6, Instant.now().getEpochSecond());
                ps.executeUpdate();
            }
            c.commit();
            if (mc.getMetricsService() != null) {
                mc.getMetricsService().incDeliveries(success);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to log delivery: " + e.getMessage());
        }
    }

    private void executeCommand(String command) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)DeliveryService.stripLeadingSlash(command)));
    }

    private static String stripLeadingSlash(String s2) {
        return s2.startsWith("/") ? s2.substring(1) : s2;
    }

    private static String applyPlaceholders(String input, Map<String, String> ctx) {
        String out = input;
        for (Map.Entry<String, String> e : ctx.entrySet()) {
            out = out.replace("{" + e.getKey() + "}", e.getValue());
        }
        return out;
    }
}

