/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.delivery;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.texboobcat.mineCommerce.MineCommerce;

public class QueuedDeliveryListener
implements Listener {
    private final MineCommerce plugin;
    private final Gson gson = new Gson();

    public QueuedDeliveryListener(MineCommerce plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                Connection c = this.plugin.getDatabaseManager().getConnection();
                try (PreparedStatement ps = c.prepareStatement("SELECT id, payload FROM orders WHERE status=? AND player_uuid=?");){
                    ps.setString(1, "pending");
                    ps.setString(2, uuid.toString());
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            boolean ok;
                            String orderId = rs.getString(1);
                            String payload = rs.getString(2);
                            String sku = this.extractSku(payload);
                            if (sku == null || sku.isBlank() || !(ok = this.plugin.getDeliveryService().deliverSkuToPlayer(player, sku, orderId))) continue;
                            this.markFulfilled(orderId);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().warning("Queued delivery failed: " + e.getMessage());
            }
        });
    }

    private String extractSku(String json) {
        try {
            JsonObject obj = this.gson.fromJson(json, JsonObject.class);
            if (obj != null && obj.has("sku") && !obj.get("sku").isJsonNull()) {
                return obj.get("sku").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void markFulfilled(String orderId) {
        try {
            Connection c = this.plugin.getDatabaseManager().getConnection();
            long now = Instant.now().getEpochSecond();
            try (PreparedStatement up = c.prepareStatement("UPDATE orders SET status=?, updated_at=? WHERE id=?");){
                up.setString(1, "fulfilled");
                up.setLong(2, now);
                up.setString(3, orderId);
                up.executeUpdate();
            }
            c.commit();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to update order status: " + e.getMessage());
        }
    }
}

