/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.integrations;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyService {
    private final Logger logger;
    private Object economy;
    private Class<?> economyClass;

    public EconomyService(Logger logger) {
        this.logger = logger;
        this.tryHook();
    }

    private void tryHook() {
        try {
            this.economyClass = Class.forName("net.milkbowl.vault.economy.Economy");
        }
        catch (ClassNotFoundException e) {
            this.logger.warning("Vault not present. Currency actions will be skipped.");
            return;
        }
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(this.economyClass);
        if (rsp != null) {
            this.economy = rsp.getProvider();
            try {
                Method getName = this.economyClass.getMethod("getName", new Class[0]);
                this.logger.info("Vault economy hooked: " + String.valueOf(getName.invoke(this.economy, new Object[0])));
            }
            catch (Exception ignored) {
                this.logger.info("Vault economy hooked.");
            }
        } else {
            this.logger.warning("Vault economy not found. Currency actions will be skipped.");
        }
    }

    public boolean isAvailable() {
        return this.economy != null;
    }

    public boolean deposit(OfflinePlayer player, double amount) {
        if (!this.isAvailable()) {
            return false;
        }
        try {
            Object resp = this.economyClass.getMethod("depositPlayer", OfflinePlayer.class, Double.TYPE).invoke(this.economy, player, amount);
            return (Boolean)resp.getClass().getMethod("transactionSuccess", new Class[0]).invoke(resp, new Object[0]);
        }
        catch (Exception e) {
            this.logger.warning("Vault deposit failed: " + e.getMessage());
            return false;
        }
    }

    public boolean withdraw(OfflinePlayer player, double amount) {
        if (!this.isAvailable()) {
            return false;
        }
        try {
            Object resp = this.economyClass.getMethod("withdrawPlayer", OfflinePlayer.class, Double.TYPE).invoke(this.economy, player, amount);
            return (Boolean)resp.getClass().getMethod("transactionSuccess", new Class[0]).invoke(resp, new Object[0]);
        }
        catch (Exception e) {
            this.logger.warning("Vault withdraw failed: " + e.getMessage());
            return false;
        }
    }
}

