/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.integrations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.UUID;
import java.util.logging.Logger;

public class PermissionsService {
    private final Logger logger;
    private Object luckPerms;
    private boolean available;

    public PermissionsService(Logger logger) {
        this.logger = logger;
        try {
            Class<?> providerCls = Class.forName("net.luckperms.api.LuckPermsProvider");
            Method get = providerCls.getMethod("get", new Class[0]);
            this.luckPerms = get.invoke(null, new Object[0]);
            boolean bl = this.available = this.luckPerms != null;
            if (this.available) {
                logger.info("LuckPerms API detected.");
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            this.available = false;
            logger.warning("LuckPerms not available. Permission actions will be skipped.");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.available = false;
            logger.warning("LuckPerms initialization failed: " + e.getMessage());
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean addGroup(UUID uuid, String group, int durationDays) {
        if (!this.available) {
            return false;
        }
        try {
            Object user = this.ensureUser(uuid);
            if (user == null) {
                return false;
            }
            Object node = this.buildInheritanceNode(group, durationDays);
            Object dataMut = user.getClass().getMethod("data", new Class[0]).invoke(user, new Object[0]);
            dataMut.getClass().getMethod("add", Class.forName("net.luckperms.api.node.Node")).invoke(dataMut, node);
            Object userManager = this.luckPerms.getClass().getMethod("getUserManager", new Class[0]).invoke(this.luckPerms, new Object[0]);
            userManager.getClass().getMethod("saveUser", user.getClass()).invoke(userManager, user);
            return true;
        }
        catch (Exception e) {
            this.logger.warning("LuckPerms addGroup failed: " + e.getMessage());
            return false;
        }
    }

    public boolean removeGroup(UUID uuid, String group) {
        if (!this.available) {
            return false;
        }
        try {
            Object user = this.ensureUser(uuid);
            if (user == null) {
                return false;
            }
            Object node = this.buildInheritanceNode(group, 0);
            Object dataMut = user.getClass().getMethod("data", new Class[0]).invoke(user, new Object[0]);
            dataMut.getClass().getMethod("remove", Class.forName("net.luckperms.api.node.Node")).invoke(dataMut, node);
            Object userManager = this.luckPerms.getClass().getMethod("getUserManager", new Class[0]).invoke(this.luckPerms, new Object[0]);
            userManager.getClass().getMethod("saveUser", user.getClass()).invoke(userManager, user);
            return true;
        }
        catch (Exception e) {
            this.logger.warning("LuckPerms removeGroup failed: " + e.getMessage());
            return false;
        }
    }

    private Object ensureUser(UUID uuid) throws Exception {
        Object userManager = this.luckPerms.getClass().getMethod("getUserManager", new Class[0]).invoke(this.luckPerms, new Object[0]);
        Object user = userManager.getClass().getMethod("getUser", UUID.class).invoke(userManager, uuid);
        if (user == null) {
            Object comp = userManager.getClass().getMethod("loadUser", UUID.class).invoke(userManager, uuid);
            comp.getClass().getMethod("join", new Class[0]).invoke(comp, new Object[0]);
            user = userManager.getClass().getMethod("getUser", UUID.class).invoke(userManager, uuid);
        }
        return user;
    }

    private Object buildInheritanceNode(String group, int durationDays) throws Exception {
        Class<?> cls = Class.forName("net.luckperms.api.node.types.InheritanceNode");
        Method builderM = cls.getMethod("builder", String.class);
        Object builder = builderM.invoke(null, group);
        if (durationDays > 0) {
            Method expiry = builder.getClass().getMethod("expiry", Duration.class);
            expiry.invoke(builder, Duration.ofDays(durationDays));
        }
        return builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
    }
}

