/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.link;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;

public class LinkService {
    private final JavaPlugin plugin;
    private final Connection connection;
    private final Logger logger;

    public LinkService(JavaPlugin plugin, Connection connection) {
        this.plugin = plugin;
        this.connection = connection;
        this.logger = plugin.getLogger();
    }

    public String generateLinkCode(String customerId, int length, int ttlSeconds) throws SQLException {
        String code = LinkService.randomAlphaNum(length);
        String hash = LinkService.sha256(code);
        long now = Instant.now().getEpochSecond();
        long expiresAt = now + (long)ttlSeconds;
        try (PreparedStatement del = this.connection.prepareStatement("DELETE FROM link_codes WHERE code_hash=?");){
            del.setString(1, hash);
            del.executeUpdate();
        }
        try (PreparedStatement ins = this.connection.prepareStatement("INSERT INTO link_codes (code_hash, customer_id, uuid, expires_at, created_at) VALUES (?,?,?,?,?)");){
            ins.setString(1, hash);
            ins.setString(2, customerId);
            ins.setString(3, null);
            ins.setLong(4, expiresAt);
            ins.setLong(5, now);
            ins.executeUpdate();
        }
        this.connection.commit();
        return code;
    }

    public boolean claimCode(UUID uuid, String code) throws SQLException {
        String hash = LinkService.sha256(code);
        long now = Instant.now().getEpochSecond();
        String select = "SELECT customer_id, expires_at FROM link_codes WHERE code_hash=?";
        try (PreparedStatement ps = this.connection.prepareStatement(select);){
            boolean bl;
            block20: {
                String customerId;
                ResultSet rs;
                block18: {
                    boolean bl2;
                    block19: {
                        block16: {
                            boolean bl3;
                            block17: {
                                ps.setString(1, hash);
                                rs = ps.executeQuery();
                                try {
                                    if (rs.next()) break block16;
                                    bl3 = false;
                                    if (rs == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return bl3;
                        }
                        customerId = rs.getString(1);
                        long expiresAt = rs.getLong(2);
                        if (expiresAt >= now) break block18;
                        this.deleteCode(hash);
                        bl2 = false;
                        if (rs == null) break block19;
                        rs.close();
                    }
                    return bl2;
                }
                this.upsertPlayer(uuid, customerId);
                this.deleteCode(hash);
                bl = true;
                if (rs == null) break block20;
                rs.close();
            }
            return bl;
        }
    }

    public String getLinkedCustomerId(UUID uuid) throws SQLException {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT customer_id FROM players WHERE uuid=?");){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    String string = rs.getString(1);
                    return string;
                }
            }
        }
        return null;
    }

    public void adminLinkDirect(String customerId, UUID uuid) throws SQLException {
        this.upsertPlayer(uuid, customerId);
    }

    private void upsertPlayer(UUID uuid, String customerId) throws SQLException {
        int updated;
        long now = Instant.now().getEpochSecond();
        try (PreparedStatement upd = this.connection.prepareStatement("UPDATE players SET customer_id=? WHERE uuid=?");){
            upd.setString(1, customerId);
            upd.setString(2, uuid.toString());
            updated = upd.executeUpdate();
        }
        if (updated == 0) {
            try (PreparedStatement ins = this.connection.prepareStatement("INSERT INTO players (uuid, customer_id, created_at) VALUES (?,?,?)");){
                ins.setString(1, uuid.toString());
                ins.setString(2, customerId);
                ins.setLong(3, now);
                ins.executeUpdate();
            }
        }
        this.connection.commit();
    }

    private void deleteCode(String hash) throws SQLException {
        try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM link_codes WHERE code_hash=?");){
            ps.setString(1, hash);
            ps.executeUpdate();
            this.connection.commit();
        }
    }

    private static String randomAlphaNum(int len) {
        String chars = "ABCDEFGHJKLMNPQRSTUVWXYZ23456789";
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append("ABCDEFGHJKLMNPQRSTUVWXYZ23456789".charAt(((Random)rnd).nextInt("ABCDEFGHJKLMNPQRSTUVWXYZ23456789".length())));
        }
        return sb.toString();
    }

    private static String sha256(String s2) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] d = md.digest(s2.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte b : d) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

