/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.rest;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.texboobcat.mineCommerce.MineCommerce;
import org.texboobcat.mineCommerce.metrics.MetricsService;

public class RestServer {
    private final MineCommerce plugin;
    private final Gson gson = new Gson();
    private HttpServer server;
    private ExecutorService executor;

    public RestServer(MineCommerce plugin) {
        this.plugin = plugin;
    }

    public void start() throws IOException {
        int port = this.plugin.getConfig().getInt("server.http_port", 8443);
        this.server = HttpServer.create(new InetSocketAddress(port), 0);
        this.server.createContext("/api/v1/health", new HealthHandler(this));
        this.server.createContext("/api/v1/orders", new OrdersHandler());
        this.server.createContext("/api/v1/orders/", new OrderStatusHandler());
        this.server.createContext("/api/v1/refunds", new RefundsHandler());
        this.server.createContext("/api/v1/sync", new SyncWebhookHandler());
        this.server.createContext("/api/v1/webhooks/woocommerce", new WooWebhookHandler());
        this.server.createContext("/api/v1/webhooks/shopify", new ShopifyWebhookHandler());
        this.server.createContext("/api/v1/metrics", new MetricsHandler());
        this.executor = Executors.newFixedThreadPool(4);
        this.server.setExecutor(this.executor);
        this.server.start();
        this.plugin.getLogger().info("REST API started on port " + port);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.plugin.getLogger().info("REST API stopped.");
    }

    private boolean verify(HttpExchange exchange, String body) throws IOException {
        long tsLong;
        boolean verifySsl = this.plugin.getConfig().getBoolean("security.verify_ssl", true);
        long maxAge = this.plugin.getConfig().getLong("security.max_webhook_age_seconds", 600L);
        String secret = this.plugin.getConfig().getString("server.webhook_secret", "CHANGE_ME");
        Headers h2 = exchange.getRequestHeaders();
        String sig = h2.getFirst("X-Signature");
        String ts = h2.getFirst("X-Timestamp");
        if (sig == null || ts == null) {
            return false;
        }
        try {
            tsLong = Long.parseLong(ts);
        }
        catch (NumberFormatException e) {
            return false;
        }
        long now = Instant.now().getEpochSecond();
        if (Math.abs(now - tsLong) > maxAge) {
            return false;
        }
        String msg = ts + "." + body;
        String computed = RestServer.hmacSHA256(secret, msg);
        return RestServer.constantTimeEquals(sig, computed);
    }

    private static String readBody(InputStream is) throws IOException {
        return new String(is.readAllBytes(), StandardCharsets.UTF_8);
    }

    private static void send(HttpExchange ex, int status, String body) throws IOException {
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        ex.getResponseHeaders().add("Content-Type", "application/json");
        ex.sendResponseHeaders(status, bytes.length);
        try (OutputStream os = ex.getResponseBody();){
            os.write(bytes);
        }
    }

    private static Optional<String> optString(JsonObject o, String key) {
        return o != null && o.has(key) && !o.get(key).isJsonNull() ? Optional.of(o.get(key).getAsString()) : Optional.empty();
    }

    private static String hmacSHA256(String secret, String message) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] raw = mac.doFinal(message.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte b : raw) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean constantTimeEquals(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length() != b.length()) {
            return false;
        }
        int r = 0;
        for (int i = 0; i < a.length(); ++i) {
            r |= a.charAt(i) ^ b.charAt(i);
        }
        return r == 0;
    }

    private class HealthHandler
    implements HttpHandler {
        private HealthHandler(RestServer restServer) {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"GET".equalsIgnoreCase(exchange.getRequestMethod())) {
                RestServer.send(exchange, 405, "{}");
                return;
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("status", "ok");
            RestServer.send(exchange, 200, obj.toString());
        }
    }

    private class OrdersHandler
    implements HttpHandler {
        private OrdersHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"POST".equalsIgnoreCase(exchange.getRequestMethod())) {
                RestServer.send(exchange, 405, "{}");
                return;
            }
            String body = RestServer.readBody(exchange.getRequestBody());
            if (!RestServer.this.verify(exchange, body)) {
                RestServer.send(exchange, 401, "{}");
                return;
            }
            JsonObject json = RestServer.this.gson.fromJson(body, JsonObject.class);
            String orderId = RestServer.optString(json, "order_id").orElse(null);
            String sku = RestServer.optString(json, "sku").orElse(null);
            String playerUuid = RestServer.optString(json, "uuid").orElse(null);
            String customerId = RestServer.optString(json, "customer_id").orElse(null);
            if (orderId == null || sku == null) {
                RestServer.send(exchange, 400, "{\"error\":\"order_id and sku required\"}");
                return;
            }
            try {
                this.storeOrder(orderId, playerUuid, customerId, body);
            }
            catch (SQLException e) {
                RestServer.this.plugin.getLogger().severe("Order store error: " + e.getMessage());
                RestServer.send(exchange, 500, "{\"error\":\"db_error\"}");
                return;
            }
            if (playerUuid != null) {
                try {
                    UUID uuid = UUID.fromString(playerUuid);
                    Player p = Bukkit.getPlayer((UUID)uuid);
                    if (p != null && p.isOnline()) {
                        Bukkit.getScheduler().runTask((Plugin)RestServer.this.plugin, () -> {
                            boolean ok = RestServer.this.plugin.getDeliveryService().deliverSkuToPlayer(p, sku, orderId);
                            RestServer.this.plugin.getLogger().info("Delivered order " + orderId + " sku=" + sku + " online=" + ok);
                            if (ok) {
                                try (PreparedStatement up = RestServer.this.plugin.getDatabaseManager().getConnection().prepareStatement("UPDATE orders SET status=?, updated_at=? WHERE id=?");){
                                    up.setString(1, "fulfilled");
                                    up.setLong(2, Instant.now().getEpochSecond());
                                    up.setString(3, orderId);
                                    up.executeUpdate();
                                }
                                catch (Exception e) {
                                    RestServer.this.plugin.getLogger().warning("Failed to update order status: " + e.getMessage());
                                }
                                try {
                                    RestServer.this.plugin.getDatabaseManager().getConnection().commit();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    } else {
                        RestServer.this.plugin.getLogger().info("Queued order " + orderId + " for offline player " + playerUuid);
                    }
                }
                catch (IllegalArgumentException uuid) {
                    // empty catch block
                }
            }
            JsonObject resp = new JsonObject();
            resp.addProperty("status", "accepted");
            RestServer.send(exchange, 202, resp.toString());
            if (RestServer.this.plugin.getMetricsService() != null) {
                RestServer.this.plugin.getMetricsService().incOrdersReceived();
            }
        }

        private void storeOrder(String orderId, String playerUuid, String customerId, String payload) throws SQLException {
            int updated;
            Connection c = RestServer.this.plugin.getDatabaseManager().getConnection();
            long now = Instant.now().getEpochSecond();
            try (PreparedStatement up = c.prepareStatement("UPDATE orders SET player_uuid=?, status=?, idempotency_key=?, payload=?, updated_at=? WHERE id=?");){
                up.setString(1, playerUuid);
                up.setString(2, "pending");
                up.setString(3, orderId);
                up.setString(4, payload);
                up.setLong(5, now);
                up.setString(6, orderId);
                updated = up.executeUpdate();
            }
            if (updated == 0) {
                try (PreparedStatement ins = c.prepareStatement("INSERT INTO orders (id, player_uuid, status, idempotency_key, payload, created_at, updated_at) VALUES (?,?,?,?,?,?,?)");){
                    ins.setString(1, orderId);
                    ins.setString(2, playerUuid);
                    ins.setString(3, "pending");
                    ins.setString(4, orderId);
                    ins.setString(5, payload);
                    ins.setLong(6, now);
                    ins.setLong(7, now);
                    ins.executeUpdate();
                }
            }
            c.commit();
        }
    }

    private class OrderStatusHandler
    implements HttpHandler {
        private OrderStatusHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String prefix;
            if (!"GET".equalsIgnoreCase(exchange.getRequestMethod())) {
                RestServer.send(exchange, 405, "{}");
                return;
            }
            String path = exchange.getRequestURI().getPath();
            if (!path.startsWith(prefix = "/api/v1/orders/") || path.length() <= prefix.length()) {
                RestServer.send(exchange, 400, "{\"error\":\"order id required\"}");
                return;
            }
            String orderId = path.substring(prefix.length());
            if (!RestServer.this.verify(exchange, "")) {
                RestServer.send(exchange, 401, "{}");
                return;
            }
            JsonObject resp = new JsonObject();
            try {
                Connection c = RestServer.this.plugin.getDatabaseManager().getConnection();
                try (PreparedStatement ps = c.prepareStatement("SELECT status, player_uuid, created_at, updated_at FROM orders WHERE id=?");){
                    ps.setString(1, orderId);
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs.next()) {
                            resp.addProperty("id", orderId);
                            resp.addProperty("status", rs.getString(1));
                            resp.addProperty("uuid", rs.getString(2));
                            resp.addProperty("created_at", rs.getLong(3));
                            resp.addProperty("updated_at", rs.getLong(4));
                            RestServer.send(exchange, 200, resp.toString());
                            return;
                        }
                    }
                }
                RestServer.send(exchange, 404, "{\"error\":\"not_found\"}");
            }
            catch (SQLException e) {
                RestServer.this.plugin.getLogger().severe("Order status error: " + e.getMessage());
                RestServer.send(exchange, 500, "{\"error\":\"db_error\"}");
            }
        }
    }

    private class RefundsHandler
    implements HttpHandler {
        private RefundsHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"POST".equalsIgnoreCase(exchange.getRequestMethod())) {
                RestServer.send(exchange, 405, "{}");
                return;
            }
            String body = RestServer.readBody(exchange.getRequestBody());
            if (!RestServer.this.verify(exchange, body)) {
                RestServer.send(exchange, 401, "{}");
                return;
            }
            JsonObject json = RestServer.this.gson.fromJson(body, JsonObject.class);
            String orderId = RestServer.optString(json, "order_id").orElse(null);
            String sku = RestServer.optString(json, "sku").orElse(null);
            String playerUuid = RestServer.optString(json, "uuid").orElse(null);
            if (orderId == null) {
                RestServer.send(exchange, 400, "{\"error\":\"order_id required\"}");
                return;
            }
            try {
                Connection c = RestServer.this.plugin.getDatabaseManager().getConnection();
                long now = Instant.now().getEpochSecond();
                try (PreparedStatement up = c.prepareStatement("UPDATE orders SET status=?, updated_at=? WHERE id=?");){
                    up.setString(1, "refunded");
                    up.setLong(2, now);
                    up.setString(3, orderId);
                    up.executeUpdate();
                }
                c.commit();
            }
            catch (SQLException e) {
                RestServer.this.plugin.getLogger().severe("Refund update error: " + e.getMessage());
                RestServer.send(exchange, 500, "{\"error\":\"db_error\"}");
                return;
            }
            if (sku != null && playerUuid != null) {
                try {
                    UUID uuid = UUID.fromString(playerUuid);
                    Player p = Bukkit.getPlayer((UUID)uuid);
                    if (p != null && p.isOnline()) {
                        boolean ok = RestServer.this.plugin.getDeliveryService().revokeSkuFromPlayer(p, sku, orderId);
                        RestServer.this.plugin.getLogger().info("Refund revoke order " + orderId + " sku=" + sku + " online=" + ok);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            RestServer.send(exchange, 202, "{\"status\":\"accepted\"}");
        }
    }

    private class SyncWebhookHandler
    implements HttpHandler {
        private SyncWebhookHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"POST".equalsIgnoreCase(exchange.getRequestMethod())) {
                RestServer.send(exchange, 405, "{}");
                return;
            }
            String body = RestServer.readBody(exchange.getRequestBody());
            if (!RestServer.this.verify(exchange, body)) {
                RestServer.send(exchange, 401, "{}");
                return;
            }
            try {
                RestServer.this.plugin.getCommerceSyncService().syncNowAsync(RestServer.this.plugin.getLogger());
            }
            catch (Exception e) {
                RestServer.this.plugin.getLogger().warning("Failed to enqueue sync: " + e.getMessage());
                RestServer.send(exchange, 500, "{\"error\":\"enqueue_failed\"}");
                return;
            }
            RestServer.send(exchange, 202, "{\"status\":\"accepted\"}");
        }
    }

    private class WooWebhookHandler
    implements HttpHandler {
        private WooWebhookHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            long id;
            if (!"POST".equalsIgnoreCase(exchange.getRequestMethod())) {
                RestServer.send(exchange, 405, "{}");
                return;
            }
            String body = RestServer.readBody(exchange.getRequestBody());
            if (!RestServer.this.verify(exchange, body)) {
                RestServer.send(exchange, 401, "{}");
                return;
            }
            JsonObject json = RestServer.this.gson.fromJson(body, JsonObject.class);
            String resource = RestServer.optString(json, "resource").orElse("");
            long l = id = json.has("id") && json.get("id").isJsonPrimitive() ? json.get("id").getAsLong() : -1L;
            if (id <= 0L) {
                RestServer.send(exchange, 200, "{\"status\":\"ignored\"}");
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)RestServer.this.plugin, () -> {
                try {
                    if ("product".equalsIgnoreCase(resource)) {
                        RestServer.this.plugin.getCommerceSyncService().deltaUpdateWooProduct(id);
                    } else if ("product_category".equalsIgnoreCase(resource)) {
                        RestServer.this.plugin.getCommerceSyncService().syncNow();
                    } else {
                        RestServer.this.plugin.getLogger().info("Woo webhook unknown resource: " + resource);
                    }
                }
                catch (Exception e) {
                    RestServer.this.plugin.getLogger().warning("Woo webhook delta failed: " + e.getMessage());
                }
            });
            RestServer.send(exchange, 202, "{\"status\":\"accepted\"}");
        }
    }

    private class ShopifyWebhookHandler
    implements HttpHandler {
        private ShopifyWebhookHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            long id;
            if (!"POST".equalsIgnoreCase(exchange.getRequestMethod())) {
                RestServer.send(exchange, 405, "{}");
                return;
            }
            String body = RestServer.readBody(exchange.getRequestBody());
            if (!RestServer.this.verify(exchange, body)) {
                RestServer.send(exchange, 401, "{}");
                return;
            }
            String topic = exchange.getRequestHeaders().getFirst("X-Shopify-Topic");
            JsonObject json = RestServer.this.gson.fromJson(body, JsonObject.class);
            long l = id = json.has("id") && json.get("id").isJsonPrimitive() ? json.get("id").getAsLong() : -1L;
            if (id <= 0L) {
                RestServer.send(exchange, 200, "{\"status\":\"ignored\"}");
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)RestServer.this.plugin, () -> {
                try {
                    if (topic != null && topic.startsWith("products/")) {
                        RestServer.this.plugin.getCommerceSyncService().deltaUpdateShopifyProduct(id);
                    } else if (topic != null && topic.startsWith("collections/")) {
                        RestServer.this.plugin.getCommerceSyncService().syncNow();
                    } else {
                        RestServer.this.plugin.getLogger().info("Shopify webhook topic: " + topic);
                    }
                }
                catch (Exception e) {
                    RestServer.this.plugin.getLogger().warning("Shopify webhook delta failed: " + e.getMessage());
                }
            });
            RestServer.send(exchange, 202, "{\"status\":\"accepted\"}");
        }
    }

    private class MetricsHandler
    implements HttpHandler {
        private MetricsHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"GET".equalsIgnoreCase(exchange.getRequestMethod())) {
                RestServer.send(exchange, 405, "{}");
                return;
            }
            MetricsService m4 = RestServer.this.plugin.getMetricsService();
            StringBuilder sb = new StringBuilder();
            sb.append("# TYPE minecommerce_orders_received counter\n");
            sb.append("minecommerce_orders_received ").append(m4.getOrdersReceived()).append('\n');
            sb.append("# TYPE minecommerce_deliveries_total counter\n");
            sb.append("minecommerce_deliveries_total ").append(m4.getDeliveriesTotal()).append('\n');
            sb.append("# TYPE minecommerce_deliveries_failed counter\n");
            sb.append("minecommerce_deliveries_failed ").append(m4.getDeliveriesFailed()).append('\n');
            byte[] bytes = sb.toString().getBytes(StandardCharsets.UTF_8);
            exchange.getResponseHeaders().add("Content-Type", "text/plain; version=0.0.4");
            exchange.sendResponseHeaders(200, bytes.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(bytes);
            }
        }
    }
}

