/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.store;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.ModalForm;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.texboobcat.mineCommerce.MineCommerce;
import org.texboobcat.mineCommerce.config.MappingsLoader;
import org.texboobcat.mineCommerce.store.QRMapUtil;
import org.texboobcat.mineCommerce.store.StoreLinkBuilder;

public class BedrockUIService {
    private final MineCommerce plugin;

    public BedrockUIService(MineCommerce plugin) {
        this.plugin = plugin;
    }

    public boolean isBedrock(Player player) {
        try {
            if (FloodgateApi.getInstance() != null && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class<?> apiCls = Class.forName("org.geysermc.geyser.api.GeyserApi");
            Object api = apiCls.getMethod("api", new Class[0]).invoke(null, new Object[0]);
            Object conn = apiCls.getMethod("connectionByUuid", UUID.class).invoke(api, player.getUniqueId());
            return conn != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void open(Player player) {
        if (!this.isBedrock(player)) {
            return;
        }
        if (!this.plugin.getMappingsLoader().getCategories().isEmpty()) {
            this.openCategories(player);
        } else {
            this.openProducts(player, null);
        }
    }

    private void openCategories(Player player) {
        FloodgatePlayer fp = this.getFloodgatePlayer(player);
        Map<String, MappingsLoader.Category> categories = this.plugin.getMappingsLoader().getCategories();
        SimpleForm.Builder form = (SimpleForm.Builder)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title("Store Categories")).content("Select a category").closedOrInvalidResultHandler(() -> {})).validResultHandler(response -> {
            int idx = response.clickedButtonId();
            String key = (String)new ArrayList(categories.keySet()).get(idx);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.openProducts(player, key));
        });
        boolean useImages = this.plugin.getConfig().getBoolean("sync.image_as_button", true);
        for (Map.Entry<String, MappingsLoader.Category> e : categories.entrySet()) {
            MappingsLoader.Category cat = e.getValue();
            if (useImages && cat.image != null && !cat.image.isBlank()) {
                form.button(cat.name, FormImage.of((FormImage.Type)FormImage.Type.URL, (String)cat.image));
                continue;
            }
            form.button(cat.name);
        }
        Form built = form.build();
        if (!this.sendForm(player, built)) {
            this.fallbackNoForms(player);
        }
    }

    private boolean hasFloodgate() {
        try {
            return FloodgateApi.getInstance() != null;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    private FloodgatePlayer getFloodgatePlayer(Player player) {
        try {
            FloodgateApi api = FloodgateApi.getInstance();
            return api != null ? api.getPlayer(player.getUniqueId()) : null;
        }
        catch (Throwable t2) {
            return null;
        }
    }

    private Object getGeyserConnection(Player player) {
        try {
            Class<?> apiCls = Class.forName("org.geysermc.geyser.api.GeyserApi");
            Object api = apiCls.getMethod("api", new Class[0]).invoke(null, new Object[0]);
            Object optional = apiCls.getMethod("connectionByUuid", UUID.class).invoke(api, player.getUniqueId());
            if (optional == null) {
                return null;
            }
            if (optional instanceof Optional) {
                Optional opt = (Optional)optional;
                return opt.orElse(null);
            }
            return optional;
        }
        catch (Throwable t2) {
            return null;
        }
    }

    private boolean sendForm(Player player, Object form) {
        try {
            FloodgatePlayer fp = this.getFloodgatePlayer(player);
            if (fp != null) {
                fp.sendForm((Form)form);
                return true;
            }
        }
        catch (Throwable fp) {
            // empty catch block
        }
        try {
            Object conn = this.getGeyserConnection(player);
            if (conn != null) {
                Class<?> formIface = Class.forName("org.geysermc.cumulus.form.Form");
                conn.getClass().getMethod("sendForm", formIface).invoke(conn, form);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private void fallbackNoForms(Player player) {
        String url = this.plugin.getConfig().getString("server.store_url", "https://example.com/store");
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "Link: " + String.valueOf(ChatColor.UNDERLINE) + url);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            ItemStack map = QRMapUtil.createQrMap(this.plugin, url, "Open Store");
            if (map != null) {
                player.getInventory().addItem(new ItemStack[]{map});
            }
        });
    }

    private void sendLinkAndQr(Player player, String sku) {
        String url = StoreLinkBuilder.buildUrl(this.plugin, sku);
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "Link: " + String.valueOf(ChatColor.UNDERLINE) + url);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            ItemStack map = QRMapUtil.createQrMap(this.plugin, url, "Open Store");
            if (map != null) {
                player.getInventory().addItem(new ItemStack[]{map});
            }
        });
    }

    private void openProducts(Player player, String categoryKey) {
        Form built;
        List<MappingsLoader.ProductMapping> list = categoryKey == null ? new ArrayList<MappingsLoader.ProductMapping>(this.plugin.getMappingsLoader().getAll()) : this.plugin.getMappingsLoader().getProductsForCategory(categoryKey);
        list.sort(Comparator.comparing(pm -> pm.name != null ? pm.name : pm.sku));
        SimpleForm.Builder form = (SimpleForm.Builder)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title("Store")).content("Choose a product").closedOrInvalidResultHandler(() -> {})).validResultHandler(response -> {
            int idx = response.clickedButtonId();
            if (idx < 0 || idx >= list.size()) {
                return;
            }
            MappingsLoader.ProductMapping p = (MappingsLoader.ProductMapping)list.get(idx);
            this.confirmAndSend(player, p.sku);
        });
        boolean useImages = this.plugin.getConfig().getBoolean("sync.image_as_button", true);
        for (MappingsLoader.ProductMapping p : list) {
            Object label;
            Object object = label = p.name != null ? p.name : p.sku;
            if (p.price >= 0.0) {
                label = (String)label + " - $" + String.format(Locale.US, "%.2f", p.price);
            }
            String image = p.image;
            if (useImages && image != null && !image.isBlank()) {
                form.button((String)label, FormImage.of((FormImage.Type)FormImage.Type.URL, (String)image));
                continue;
            }
            form.button((String)label);
        }
        if (categoryKey != null) {
            form.button("\u00ab Back to Categories");
        }
        if (!this.sendForm(player, built = form.build())) {
            this.fallbackNoForms(player);
        }
    }

    private void confirmAndSend(Player player, String sku) {
        String url = StoreLinkBuilder.buildUrl(this.plugin, sku);
        ModalForm.Builder form = (ModalForm.Builder)((ModalForm.Builder)((ModalForm.Builder)ModalForm.builder().title("Confirm Purchase")).content("Open store page for SKU: " + sku + "?\nA QR code map will be given to you.").button1("Confirm").button2("Cancel").closedOrInvalidResultHandler(() -> {})).validResultHandler(result -> {
            if (!result.clickedFirst()) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                ItemStack map = QRMapUtil.createQrMap(this.plugin, url, "Open Store");
                if (map != null) {
                    player.getInventory().addItem(new ItemStack[]{map});
                }
                player.sendMessage(String.valueOf(ChatColor.AQUA) + "Link: " + String.valueOf(ChatColor.UNDERLINE) + url);
            });
        });
        Form built = form.build();
        if (!this.sendForm(player, built)) {
            this.sendLinkAndQr(player, sku);
        }
    }
}

