/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.store;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.jetbrains.annotations.Nullable;
import org.texboobcat.mineCommerce.MineCommerce;

public final class QRMapUtil {
    private QRMapUtil() {
    }

    @Nullable
    public static ItemStack createQrMap(MineCommerce plugin, String url, String title) {
        try {
            BufferedImage qr = QRMapUtil.generateQr(url, 256);
            BufferedImage scaled = new BufferedImage(128, 128, 1);
            Graphics2D g2 = scaled.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, 128, 128);
            g2.drawImage(qr, 0, 0, 128, 128, null);
            g2.dispose();
            MapView view = Bukkit.createMap((World)((World)Bukkit.getWorlds().get(0)));
            view.getRenderers().forEach(arg_0 -> ((MapView)view).removeRenderer(arg_0));
            view.addRenderer((MapRenderer)new ImageRenderer(scaled));
            ItemStack map = new ItemStack(Material.FILLED_MAP);
            MapMeta meta = (MapMeta)map.getItemMeta();
            if (meta != null) {
                meta.setMapView(view);
                meta.setDisplayName(title);
                map.setItemMeta((ItemMeta)meta);
            }
            return map;
        }
        catch (Exception e) {
            plugin.getLogger().warning("Failed to generate QR map: " + e.getMessage());
            return null;
        }
    }

    private static BufferedImage generateQr(String text, int size) throws Exception {
        QRCodeWriter writer = new QRCodeWriter();
        EnumMap<EncodeHintType, Integer> hints = new EnumMap<EncodeHintType, Integer>(EncodeHintType.class);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = writer.encode(text, BarcodeFormat.QR_CODE, size, size, hints);
        BufferedImage img = new BufferedImage(size, size, 1);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                img.setRGB(x, y, bitMatrix.get(x, y) ? 0 : 0xFFFFFF);
            }
        }
        return img;
    }

    private static class ImageRenderer
    extends MapRenderer {
        private final BufferedImage image;
        private boolean rendered = false;

        public ImageRenderer(BufferedImage image) {
            this.image = image;
        }

        public void render(MapView map, MapCanvas canvas, Player player) {
            if (this.rendered) {
                return;
            }
            this.rendered = true;
            canvas.drawImage(0, 0, (Image)MapPalette.resizeImage((Image)this.image));
        }
    }
}

