/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.store;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.texboobcat.mineCommerce.MineCommerce;
import org.texboobcat.mineCommerce.config.MappingsLoader;
import org.texboobcat.mineCommerce.store.StoreGuiConfig;
import org.texboobcat.mineCommerce.store.StoreLinkBuilder;

public class StoreGui
implements Listener {
    private final MineCommerce plugin;
    private final Map<UUID, Map<Integer, String>> openViews = new HashMap<UUID, Map<Integer, String>>();
    private final Map<UUID, State> states = new HashMap<UUID, State>();

    public StoreGui(MineCommerce plugin) {
        this.plugin = plugin;
    }

    public void open(Player player) {
        if (!this.plugin.getMappingsLoader().getCategories().isEmpty()) {
            this.openCategories(player);
        } else {
            this.openProducts(player, null, 0);
        }
    }

    private void openCategories(Player player) {
        StoreGuiConfig cfg = this.plugin.getStoreGuiConfig();
        int size = Math.min(54, Math.max(9, cfg.getRows() * 9));
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)size, (String)cfg.getCategoriesTitle());
        HashMap<Integer, CallSite> slots = new HashMap<Integer, CallSite>();
        int i = 0;
        for (Map.Entry<String, MappingsLoader.Category> e : this.plugin.getMappingsLoader().getCategories().entrySet()) {
            if (i >= size) break;
            MappingsLoader.Category c = e.getValue();
            ItemStack item = new ItemStack(StoreGui.parseMat(c.icon, Material.CHEST));
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.GOLD) + StoreGui.safe(c.name));
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                if (c.description != null) {
                    lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + c.description)));
                }
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Click to view")));
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            inv.setItem(i, item);
            slots.put(i, (CallSite)((Object)("cat:" + e.getKey())));
            ++i;
        }
        if (cfg.isFillEmpty()) {
            StoreGui.fillEmpty(inv);
        }
        this.states.put(player.getUniqueId(), new State(View.CATEGORIES, null, 0));
        this.openViews.put(player.getUniqueId(), slots);
        player.openInventory(inv);
    }

    private void openProducts(Player player, String categoryKey, int page) {
        boolean needNav;
        StoreGuiConfig cfg = this.plugin.getStoreGuiConfig();
        int rows = cfg.getRows();
        int size = Math.min(54, Math.max(9, rows * 9));
        int contentSlots = rows >= 2 ? (rows - 1) * 9 : rows * 9;
        List<MappingsLoader.ProductMapping> list = categoryKey == null ? new ArrayList<MappingsLoader.ProductMapping>(this.plugin.getMappingsLoader().getAll()) : this.plugin.getMappingsLoader().getProductsForCategory(categoryKey);
        list.sort(Comparator.comparing(pm -> pm.name != null ? pm.name : pm.sku));
        int totalPages = Math.max(1, (int)Math.ceil((double)list.size() / (double)contentSlots));
        int current = Math.max(0, Math.min(page, totalPages - 1));
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)size, (String)cfg.getTitle());
        HashMap<Integer, Object> slots = new HashMap<Integer, Object>();
        int start = current * contentSlots;
        for (int i = 0; i < contentSlots && start + i < list.size(); ++i) {
            MappingsLoader.ProductMapping p = list.get(start + i);
            ItemStack item = new ItemStack(StoreGui.resolveIcon(cfg, p));
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.GOLD) + StoreGui.safe(p.name));
                ArrayList<String> lore = new ArrayList<String>();
                for (String line : cfg.getLore()) {
                    lore.add(StoreGui.applyPlaceholders(line, p));
                }
                meta.setLore(StoreGui.color(lore));
                item.setItemMeta(meta);
            }
            inv.setItem(i, item);
            slots.put(i, p.sku);
        }
        int base = size - 9;
        boolean bl = needNav = totalPages > 1 || !this.plugin.getMappingsLoader().getCategories().isEmpty();
        if (needNav) {
            if (current > 0) {
                inv.setItem(base + 1, StoreGui.makeButton(cfg.getPrevBtn()));
            }
            if (!this.plugin.getMappingsLoader().getCategories().isEmpty()) {
                inv.setItem(base + 4, StoreGui.makeButton(cfg.getBackBtn()));
            }
            if (current < totalPages - 1) {
                inv.setItem(base + 7, StoreGui.makeButton(cfg.getNextBtn()));
            }
            if (current > 0) {
                slots.put(base + 1, "nav:prev:" + (current - 1) + ":" + StoreGui.safe(categoryKey));
            }
            if (!this.plugin.getMappingsLoader().getCategories().isEmpty()) {
                slots.put(base + 4, "nav:back");
            }
            if (current < totalPages - 1) {
                slots.put(base + 7, "nav:next:" + (current + 1) + ":" + StoreGui.safe(categoryKey));
            }
        }
        if (cfg.isFillEmpty()) {
            StoreGui.fillEmpty(inv);
        }
        this.states.put(player.getUniqueId(), new State(View.PRODUCTS, categoryKey, current));
        this.openViews.put(player.getUniqueId(), slots);
        player.openInventory(inv);
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        HumanEntity who = e.getWhoClicked();
        if (!(who instanceof Player)) {
            return;
        }
        Player p = (Player)who;
        Map<Integer, String> slots = this.openViews.get(p.getUniqueId());
        if (slots == null) {
            return;
        }
        String title = e.getView().getTitle();
        if (title == null) {
            return;
        }
        String stripped = ChatColor.stripColor((String)title);
        String prodTitle = ChatColor.stripColor((String)this.plugin.getStoreGuiConfig().getTitle());
        String catTitle = ChatColor.stripColor((String)this.plugin.getStoreGuiConfig().getCategoriesTitle());
        if (!stripped.equals(prodTitle) && !stripped.equals(catTitle)) {
            return;
        }
        Integer slot = e.getRawSlot();
        if (slot == null) {
            return;
        }
        if (slot < 0 || slot >= e.getInventory().getSize()) {
            return;
        }
        e.setCancelled(true);
        String sku = slots.get(slot);
        if (sku == null) {
            return;
        }
        if (sku.startsWith("cat:")) {
            String key = sku.substring(4);
            this.openProducts(p, key, 0);
            return;
        }
        if (sku.startsWith("nav:")) {
            String[] parts = sku.split(":");
            if (parts.length >= 2) {
                switch (parts[1]) {
                    case "back": {
                        this.openCategories(p);
                        break;
                    }
                    case "prev": {
                        int page = Integer.parseInt(parts[2]);
                        String cat = parts.length >= 4 && !parts[3].isEmpty() ? parts[3] : null;
                        this.openProducts(p, cat, page);
                        break;
                    }
                    case "next": {
                        int page = Integer.parseInt(parts[2]);
                        String cat = parts.length >= 4 && !parts[3].isEmpty() ? parts[3] : null;
                        this.openProducts(p, cat, page);
                    }
                }
            }
            return;
        }
        String url = StoreLinkBuilder.buildUrl(this.plugin, sku);
        p.closeInventory();
        this.sendClickableUrl(p, url);
    }

    private static Material resolveIcon(StoreGuiConfig cfg, MappingsLoader.ProductMapping p) {
        if (p.icon != null) {
            try {
                return Material.valueOf((String)p.icon.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cfg.getDefaultIcon();
    }

    private static String safe(String s2) {
        return s2 == null ? "" : s2;
    }

    private static List<String> color(List<String> in) {
        ArrayList<String> out = new ArrayList<String>();
        for (String s2 : in) {
            out.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s2));
        }
        return out;
    }

    private static String applyPlaceholders(String line, MappingsLoader.ProductMapping p) {
        String desc = p.description != null ? p.description : "";
        String price = p.price >= 0.0 ? String.format(Locale.US, "%.2f", p.price) : "-";
        return ChatColor.translateAlternateColorCodes((char)'&', (String)line.replace("{name}", StoreGui.safe(p.name)).replace("{sku}", StoreGui.safe(p.sku)).replace("{description}", desc).replace("{price}", price));
    }

    private static ItemStack makeButton(StoreGuiConfig.ButtonDef def) {
        ItemStack item = new ItemStack(def.icon);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(def.name);
            item.setItemMeta(meta);
        }
        return item;
    }

    private static Material parseMat(String m4, Material fallback) {
        try {
            return Material.valueOf((String)m4.toUpperCase());
        }
        catch (Exception e) {
            return fallback;
        }
    }

    private static void fillEmpty(Inventory inv) {
        ItemStack filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta fm = filler.getItemMeta();
        if (fm != null) {
            fm.setDisplayName(" ");
            filler.setItemMeta(fm);
        }
        for (int s2 = 0; s2 < inv.getSize(); ++s2) {
            if (inv.getItem(s2) != null) continue;
            inv.setItem(s2, filler);
        }
    }

    private void sendClickableUrl(Player p, String url) {
        Component msg = Component.text((String)"Click to open purchase: ", (TextColor)NamedTextColor.AQUA).append(((TextComponent)Component.text((String)url, (TextColor)NamedTextColor.BLUE, (TextDecoration[])new TextDecoration[]{TextDecoration.UNDERLINED}).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Open in browser")))).clickEvent(ClickEvent.openUrl((String)url)));
        p.sendMessage(msg);
    }

    private static class State {
        View view;
        String categoryKey;
        int page;

        State(View v, String c, int p) {
            this.view = v;
            this.categoryKey = c;
            this.page = p;
        }
    }

    private static enum View {
        CATEGORIES,
        PRODUCTS;

    }
}

