/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.store;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class StoreGuiConfig {
    private final JavaPlugin plugin;
    private String title;
    private String categoriesTitle;
    private int rows;
    private boolean fillEmpty;
    private Material defaultIcon;
    private List<String> lore;
    private ButtonDef nextBtn;
    private ButtonDef prevBtn;
    private ButtonDef backBtn;

    public StoreGuiConfig(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void load() {
        File f = new File(this.plugin.getDataFolder(), "store_gui.yml");
        if (!f.exists()) {
            this.plugin.saveResource("store_gui.yml", false);
        }
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)f);
        this.title = StoreGuiConfig.color(cfg.getString("title", "&2Store"));
        this.categoriesTitle = StoreGuiConfig.color(cfg.getString("categories_title", "&2Store Categories"));
        this.rows = Math.max(1, Math.min(6, cfg.getInt("rows", 4)));
        this.fillEmpty = cfg.getBoolean("fill_empty", false);
        this.defaultIcon = StoreGuiConfig.parseMaterial(cfg.getString("default_icon", "PAPER"));
        this.lore = cfg.getStringList("lore");
        if (this.lore == null) {
            this.lore = new ArrayList<String>();
        }
        String nextName = cfg.getString("buttons.next.name", "&aNext \u00bb");
        String nextIcon = cfg.getString("buttons.next.icon", "LIME_STAINED_GLASS_PANE");
        this.nextBtn = new ButtonDef(StoreGuiConfig.color(nextName), StoreGuiConfig.parseMaterial(nextIcon));
        String prevName = cfg.getString("buttons.prev.name", "&a\u00ab Prev");
        String prevIcon = cfg.getString("buttons.prev.icon", "LIME_STAINED_GLASS_PANE");
        this.prevBtn = new ButtonDef(StoreGuiConfig.color(prevName), StoreGuiConfig.parseMaterial(prevIcon));
        String backName = cfg.getString("buttons.back.name", "&c\u00ab Back");
        String backIcon = cfg.getString("buttons.back.icon", "RED_STAINED_GLASS_PANE");
        this.backBtn = new ButtonDef(StoreGuiConfig.color(backName), StoreGuiConfig.parseMaterial(backIcon));
    }

    private static Material parseMaterial(String s2) {
        try {
            return Material.valueOf((String)s2.toUpperCase());
        }
        catch (Exception e) {
            return Material.PAPER;
        }
    }

    private static String color(String s2) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s2);
    }

    public String getTitle() {
        return this.title;
    }

    public String getCategoriesTitle() {
        return this.categoriesTitle;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isFillEmpty() {
        return this.fillEmpty;
    }

    public Material getDefaultIcon() {
        return this.defaultIcon;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public ButtonDef getNextBtn() {
        return this.nextBtn;
    }

    public ButtonDef getPrevBtn() {
        return this.prevBtn;
    }

    public ButtonDef getBackBtn() {
        return this.backBtn;
    }

    public static class ButtonDef {
        public final String name;
        public final Material icon;

        public ButtonDef(String name, Material icon) {
            this.name = name;
            this.icon = icon;
        }
    }
}

