/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.store;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import org.texboobcat.mineCommerce.MineCommerce;
import org.texboobcat.mineCommerce.config.MappingsLoader;

public final class StoreLinkBuilder {
    private StoreLinkBuilder() {
    }

    public static String buildUrl(MineCommerce plugin, String sku) {
        Optional<MappingsLoader.ProductMapping> opt = plugin.getMappingsLoader().getProduct(sku);
        String base = plugin.getConfig().getString("server.store_url", "https://example.com/store");
        if (opt.isPresent()) {
            String platform;
            MappingsLoader.ProductMapping p = opt.get();
            if (p.urlOverride != null && !p.urlOverride.isEmpty()) {
                return p.urlOverride;
            }
            String tpl = plugin.getConfig().getString("server.link_template", "");
            if (tpl != null && !tpl.isEmpty()) {
                return tpl.replace("{base}", base).replace("{sku}", StoreLinkBuilder.enc(sku)).replace("{product_id}", p.productId != null ? p.productId : "").replace("{variant_id}", p.variantId != null ? p.variantId : "");
            }
            switch (platform = plugin.getConfig().getString("server.platform", "generic").toLowerCase(Locale.ROOT)) {
                case "woocommerce": {
                    if (p.productId == null || p.productId.isEmpty()) break;
                    return base + (base.contains("?") ? "&" : "?") + "add-to-cart=" + StoreLinkBuilder.enc(p.productId);
                }
                case "shopify": {
                    if (p.variantId == null || p.variantId.isEmpty()) break;
                    String slash = base.endsWith("/") ? "" : "/";
                    return base + slash + "cart/" + StoreLinkBuilder.enc(p.variantId) + ":1";
                }
            }
        }
        return base + (base.contains("?") ? "&" : "?") + "sku=" + StoreLinkBuilder.enc(sku);
    }

    private static String enc(String s2) {
        return URLEncoder.encode(s2, StandardCharsets.UTF_8);
    }
}

