/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.mineCommerce.sync;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.texboobcat.mineCommerce.MineCommerce;

public class CommerceSyncService {
    private final MineCommerce plugin;
    private final HttpClient http;
    private final Gson gson = new GsonBuilder().create();
    private int scheduledTaskId = -1;

    public CommerceSyncService(MineCommerce plugin) {
        this.plugin = plugin;
        this.http = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(20L)).build();
    }

    public void startSchedulerIfEnabled() {
        FileConfiguration cfg = this.plugin.getConfig();
        if (!cfg.getBoolean("sync.enabled", false)) {
            return;
        }
        int minutes = cfg.getInt("sync.schedule_minutes", 60);
        long ticks = Math.max(1200L, (long)minutes * 60L * 20L);
        if (this.scheduledTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.scheduledTaskId);
        }
        this.scheduledTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.syncNow();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Scheduled sync failed: " + e.getMessage());
            }
        }, 40L, ticks).getTaskId();
        this.plugin.getLogger().info("CommerceSync scheduled every " + minutes + " minute(s)");
    }

    public void stopScheduler() {
        if (this.scheduledTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.scheduledTaskId);
        }
        this.scheduledTaskId = -1;
    }

    public void syncNowAsync(Logger feedback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.syncNow();
                feedback.info("MineCommerce: sync completed.");
            }
            catch (Exception e) {
                feedback.severe("MineCommerce: sync failed - " + e.getMessage());
            }
        });
    }

    public void syncNow() throws Exception {
        String platform = this.plugin.getConfig().getString("server.platform", "generic").toLowerCase(Locale.ROOT);
        LinkedHashMap<String, Product> products = new LinkedHashMap<String, Product>();
        LinkedHashMap<String, Category> categoriesByKey = new LinkedHashMap<String, Category>();
        if (platform.equals("woocommerce")) {
            JsonArray arr;
            FileConfiguration cfg = this.plugin.getConfig();
            String baseUrl = CommerceSyncService.trimTrailingSlash(cfg.getString("woocommerce.base_url", ""));
            String key = cfg.getString("woocommerce.consumer_key", "");
            String secret = cfg.getString("woocommerce.consumer_secret", "");
            if (baseUrl.isEmpty() || key.isEmpty() || secret.isEmpty()) {
                throw new IllegalStateException("WooCommerce config missing (woocommerce.base_url/consumer_key/consumer_secret)");
            }
            LinkedHashMap<Long, String> categoryIdToKey = new LinkedHashMap<Long, String>();
            int page = 1;
            while ((arr = this.getJsonArray(this.authGet(baseUrl + "/wp-json/wc/v3/products/categories?per_page=100&page=" + page, key, secret))).size() != 0) {
                for (JsonElement el : arr) {
                    JsonObject o = el.getAsJsonObject();
                    long id = o.get("id").getAsLong();
                    String name = CommerceSyncService.optString(o, "name", "Category " + id);
                    String slug = CommerceSyncService.optString(o, "slug", String.valueOf(id));
                    String keyName = slug.toLowerCase(Locale.ROOT);
                    String image = null;
                    if (o.has("image") && !o.get("image").isJsonNull()) {
                        JsonObject img = o.getAsJsonObject("image");
                        image = CommerceSyncService.optString(img, "src", null);
                    }
                    categoriesByKey.put(keyName, new Category(keyName, name, new ArrayList<String>(), image));
                    categoryIdToKey.put(id, keyName);
                }
                ++page;
            }
            page = 1;
            while ((arr = this.getJsonArray(this.authGet(baseUrl + "/wp-json/wc/v3/products?status=publish&per_page=100&page=" + page, key, secret))).size() != 0) {
                for (JsonElement el : arr) {
                    Object vars;
                    Object co;
                    JsonArray imgs;
                    JsonObject p = el.getAsJsonObject();
                    long productId = p.get("id").getAsLong();
                    String type = CommerceSyncService.optString(p, "type", "simple");
                    String name = CommerceSyncService.optString(p, "name", "Product " + productId);
                    String sku = CommerceSyncService.optString(p, "sku", String.valueOf(productId));
                    double price = CommerceSyncService.optDouble(p, "price", -1.0);
                    String description = CommerceSyncService.optString(p, "short_description", "");
                    String productImage = null;
                    if (p.has("images") && (imgs = p.getAsJsonArray("images")).size() > 0) {
                        JsonObject i0 = imgs.get(0).getAsJsonObject();
                        productImage = CommerceSyncService.optString(i0, "src", null);
                    }
                    ArrayList<Long> catIds = new ArrayList<Long>();
                    if (p.has("categories")) {
                        for (JsonElement ce : p.getAsJsonArray("categories")) {
                            co = ce.getAsJsonObject();
                            if (!((JsonObject)co).has("id")) continue;
                            catIds.add(((JsonObject)co).get("id").getAsLong());
                        }
                    }
                    if ("variable".equalsIgnoreCase(type)) {
                        int vPage = 1;
                        while (((JsonArray)(vars = this.getJsonArray(this.authGet(baseUrl + "/wp-json/wc/v3/products/" + productId + "/variations?per_page=100&page=" + vPage, key, secret)))).size() != 0) {
                            co = ((JsonArray)vars).iterator();
                            while (co.hasNext()) {
                                JsonElement ve = (JsonElement)co.next();
                                JsonObject v = ve.getAsJsonObject();
                                long variantId = v.get("id").getAsLong();
                                String vSku = CommerceSyncService.optString(v, "sku", sku + "-" + variantId);
                                double vPrice = CommerceSyncService.optDouble(v, "price", price);
                                String vImage = productImage;
                                if (v.has("image") && !v.get("image").isJsonNull()) {
                                    JsonObject vi = v.getAsJsonObject("image");
                                    vImage = CommerceSyncService.optString(vi, "src", vImage);
                                }
                                String sSku = CommerceSyncService.ensureSku(vSku, productId, variantId);
                                products.put(sSku, new Product(sSku, name, productId, String.valueOf(variantId), description, vPrice, vImage));
                                for (Long cid : catIds) {
                                    this.addSkuToCategory(categoriesByKey, (String)categoryIdToKey.get(cid), sSku);
                                }
                            }
                            ++vPage;
                        }
                        continue;
                    }
                    String sSku = CommerceSyncService.ensureSku(sku, productId, null);
                    products.put(sSku, new Product(sku == null ? sSku : sSku, name, productId, null, description, price, productImage));
                    vars = catIds.iterator();
                    while (vars.hasNext()) {
                        Long cid = (Long)vars.next();
                        this.addSkuToCategory(categoriesByKey, (String)categoryIdToKey.get(cid), sSku);
                    }
                }
                ++page;
            }
        } else if (platform.equals("shopify")) {
            List<Long> batch;
            FileConfiguration cfg = this.plugin.getConfig();
            String shop = cfg.getString("shopify.shop", "");
            String version = cfg.getString("shopify.api_version", "2024-07");
            String accessToken = cfg.getString("shopify.access_token", "");
            if (shop.isEmpty() || accessToken.isEmpty()) {
                throw new IllegalStateException("Shopify config missing (shopify.shop/access_token)");
            }
            String base = "https://" + shop + ".myshopify.com/admin/api/" + version;
            List<JsonObject> collections = this.getAllPagesArrayShopifyCursor(base + "/custom_collections.json?limit=250", accessToken, "custom_collections");
            LinkedHashMap<Long, Object> collectionIdToKey = new LinkedHashMap<Long, Object>();
            for (JsonObject c : collections) {
                long id = c.get("id").getAsLong();
                String title = CommerceSyncService.optString(c, "title", "Collection " + id);
                String handle = CommerceSyncService.optString(c, "handle", String.valueOf(id));
                String keyName = handle.toLowerCase(Locale.ROOT);
                String image = null;
                if (c.has("image") && !c.get("image").isJsonNull()) {
                    JsonObject im = c.getAsJsonObject("image");
                    image = CommerceSyncService.optString(im, "src", null);
                }
                categoriesByKey.put(keyName, new Category(keyName, title, new ArrayList<String>(), image));
                collectionIdToKey.put(id, keyName);
            }
            LinkedHashSet<Long> allProductIds = new LinkedHashSet<Long>();
            LinkedHashMap collToProducts = new LinkedHashMap();
            for (Long collId : collectionIdToKey.keySet()) {
                List<JsonObject> collects = this.getAllPagesArrayShopifyCursor(base + "/collects.json?limit=250&collection_id=" + collId, accessToken, "collects");
                ArrayList<Long> pids = new ArrayList<Long>();
                for (JsonObject co : collects) {
                    long pid = co.get("product_id").getAsLong();
                    pids.add(pid);
                    allProductIds.add(pid);
                }
                collToProducts.put(collId, pids);
            }
            ArrayList pidList = new ArrayList(allProductIds);
            HashMap<Long, JsonObject> productById = new HashMap<Long, JsonObject>();
            for (int i = 0; i < pidList.size() && !(batch = pidList.subList(i, Math.min(i + 50, pidList.size()))).isEmpty(); i += 50) {
                String idsParam = CommerceSyncService.joinIds(batch);
                JsonObject root = this.getJsonObject(this.shopifyGet(base + "/products.json?ids=" + idsParam + "&limit=250", accessToken));
                JsonArray arr = root.getAsJsonArray("products");
                for (JsonElement el : arr) {
                    JsonObject p = el.getAsJsonObject();
                    productById.put(p.get("id").getAsLong(), p);
                }
            }
            for (Map.Entry e : collToProducts.entrySet()) {
                String catKey = (String)collectionIdToKey.get(e.getKey());
                for (Long pid : (List)e.getValue()) {
                    JsonArray ims;
                    JsonObject p = (JsonObject)productById.get(pid);
                    if (p == null) continue;
                    String name = CommerceSyncService.optString(p, "title", "Product " + pid);
                    String body = CommerceSyncService.optString(p, "body_html", "");
                    String defaultImage = null;
                    if (p.has("image") && !p.get("image").isJsonNull()) {
                        JsonObject im = p.getAsJsonObject("image");
                        defaultImage = CommerceSyncService.optString(im, "src", null);
                    } else if (p.has("images") && p.get("images").isJsonArray() && (ims = p.getAsJsonArray("images")).size() > 0) {
                        defaultImage = CommerceSyncService.optString(ims.get(0).getAsJsonObject(), "src", null);
                    }
                    JsonArray variants = p.getAsJsonArray("variants");
                    HashMap<Long, String> imageById = new HashMap<Long, String>();
                    if (p.has("images") && p.get("images").isJsonArray()) {
                        for (JsonElement ie : p.getAsJsonArray("images")) {
                            JsonObject io = ie.getAsJsonObject();
                            long iid = io.get("id").getAsLong();
                            imageById.put(iid, CommerceSyncService.optString(io, "src", null));
                        }
                    }
                    for (JsonElement ve : variants) {
                        JsonObject v = ve.getAsJsonObject();
                        long vid = v.get("id").getAsLong();
                        String sku = CommerceSyncService.optString(v, "sku", pid + "-" + vid);
                        double price = CommerceSyncService.optDouble(v, "price", -1.0);
                        String img = defaultImage;
                        if (v.has("image_id") && !v.get("image_id").isJsonNull()) {
                            long iid = v.get("image_id").getAsLong();
                            img = imageById.getOrDefault(iid, img);
                        }
                        String sSku = CommerceSyncService.ensureSku(sku, pid, vid);
                        products.put(sSku, new Product(sSku, name, pid, String.valueOf(vid), body, price, img));
                        this.addSkuToCategory(categoriesByKey, catKey, sSku);
                    }
                }
            }
        } else {
            this.plugin.getLogger().info("CommerceSync skipped (server.platform not woocommerce/shopify)");
            return;
        }
        this.writeMappings(products, categoriesByKey);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getMappingsLoader().load());
    }

    private void addSkuToCategory(Map<String, Category> categoriesByKey, String key, String sku) {
        if (key == null) {
            return;
        }
        Category c = categoriesByKey.get(key);
        if (c == null) {
            return;
        }
        if (!c.skus.contains(sku)) {
            c.skus.add(sku);
        }
    }

    private void writeMappings(Map<String, Product> products, Map<String, Category> categories) throws IOException {
        String base;
        File outFile = new File(this.plugin.getDataFolder(), "mappings.yml");
        YamlConfiguration y = new YamlConfiguration();
        for (Product p : products.values()) {
            List<Map<String, Object>> actions;
            base = "products." + p.sku + ".";
            y.set(base + "name", (Object)p.name);
            if (p.description != null && !p.description.isEmpty()) {
                y.set(base + "description", (Object)CommerceSyncService.stripHtml(p.description));
            }
            if (p.price >= 0.0) {
                y.set(base + "price", (Object)p.price);
            }
            y.set(base + "product_id", (Object)String.valueOf(p.productId));
            if (p.variantId != null) {
                y.set(base + "variant_id", (Object)p.variantId);
            }
            if (p.image != null) {
                y.set(base + "image", (Object)p.image);
            }
            if ((actions = this.defaultActionsForSku(p.sku)) != null) {
                y.set(base + "actions", actions);
                continue;
            }
            y.set(base + "actions", new ArrayList());
        }
        for (Category c : categories.values()) {
            base = "categories." + c.key + ".";
            y.set(base + "name", (Object)c.name);
            y.set(base + "icon", (Object)"CHEST");
            y.set(base + "skus", c.skus);
            if (c.image == null) continue;
            y.set(base + "image", (Object)c.image);
        }
        y.save(outFile);
        this.plugin.getLogger().info("Regenerated mappings.yml (" + products.size() + " products, " + categories.size() + " categories)");
    }

    private List<Map<String, Object>> defaultActionsForSku(String sku) {
        FileConfiguration cfg = this.plugin.getConfig();
        if (!cfg.getBoolean("sync.auto_actions.enabled", false)) {
            return null;
        }
        String cmd = cfg.getString("sync.auto_actions.default_command", null);
        if (cmd == null || cmd.isBlank()) {
            return null;
        }
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("type", "command");
        action.put("command", cmd.replace("{sku}", sku));
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        list.add(action);
        return list;
    }

    public void deltaUpdateWooProduct(long productId) throws Exception {
        JsonArray imgs;
        FileConfiguration cfg = this.plugin.getConfig();
        String baseUrl = CommerceSyncService.trimTrailingSlash(cfg.getString("woocommerce.base_url", ""));
        String key = cfg.getString("woocommerce.consumer_key", "");
        String secret = cfg.getString("woocommerce.consumer_secret", "");
        if (baseUrl.isEmpty() || key.isEmpty() || secret.isEmpty()) {
            throw new IllegalStateException("WooCommerce config missing");
        }
        JsonObject p = this.getJsonObject(this.authGet(baseUrl + "/wp-json/wc/v3/products/" + productId, key, secret));
        String type = CommerceSyncService.optString(p, "type", "simple");
        String name = CommerceSyncService.optString(p, "name", "Product " + productId);
        String sku = CommerceSyncService.optString(p, "sku", String.valueOf(productId));
        double price = CommerceSyncService.optDouble(p, "price", -1.0);
        String description = CommerceSyncService.optString(p, "short_description", "");
        String productImage = null;
        if (p.has("images") && (imgs = p.getAsJsonArray("images")).size() > 0) {
            productImage = CommerceSyncService.optString(imgs.get(0).getAsJsonObject(), "src", null);
        }
        ArrayList<Long> catIds = new ArrayList<Long>();
        if (p.has("categories")) {
            for (JsonElement ce : p.getAsJsonArray("categories")) {
                JsonObject co = ce.getAsJsonObject();
                if (!co.has("id")) continue;
                catIds.add(co.get("id").getAsLong());
            }
        }
        File outFile = new File(this.plugin.getDataFolder(), "mappings.yml");
        YamlConfiguration y = YamlConfiguration.loadConfiguration((File)outFile);
        if ("variable".equalsIgnoreCase(type)) {
            JsonArray vars;
            int vPage = 1;
            while ((vars = this.getJsonArray(this.authGet(baseUrl + "/wp-json/wc/v3/products/" + productId + "/variations?per_page=100&page=" + vPage, key, secret))).size() != 0) {
                for (JsonElement ve : vars) {
                    JsonObject v = ve.getAsJsonObject();
                    long variantId = v.get("id").getAsLong();
                    String vSku = CommerceSyncService.optString(v, "sku", sku + "-" + variantId);
                    double vPrice = CommerceSyncService.optDouble(v, "price", price);
                    String vImage = productImage;
                    if (v.has("image") && !v.get("image").isJsonNull()) {
                        vImage = CommerceSyncService.optString(v.getAsJsonObject("image"), "src", vImage);
                    }
                    String sSku = CommerceSyncService.ensureSku(vSku, productId, variantId);
                    this.writeOrUpdateProductYaml(y, sSku, name, description, vPrice, String.valueOf(productId), String.valueOf(variantId), vImage);
                    this.ensureCategoriesContainSkus(y, catIds, sSku);
                }
                ++vPage;
            }
        } else {
            String sSku = CommerceSyncService.ensureSku(sku, productId, null);
            this.writeOrUpdateProductYaml(y, sSku, name, description, price, String.valueOf(productId), null, productImage);
            this.ensureCategoriesContainSkus(y, catIds, sSku);
        }
        y.save(outFile);
        this.plugin.getLogger().info("Woo delta updated product id=" + productId);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getMappingsLoader().load());
    }

    public void deltaUpdateShopifyProduct(long productId) throws Exception {
        FileConfiguration cfg = this.plugin.getConfig();
        String shop = cfg.getString("shopify.shop", "");
        String version = cfg.getString("shopify.api_version", "2024-07");
        String accessToken = cfg.getString("shopify.access_token", "");
        if (shop.isEmpty() || accessToken.isEmpty()) {
            throw new IllegalStateException("Shopify config missing");
        }
        String base = "https://" + shop + ".myshopify.com/admin/api/" + version;
        JsonObject root = this.getJsonObject(this.shopifyGet(base + "/products/" + productId + ".json", accessToken));
        if (!root.has("product")) {
            throw new IOException("Shopify product not found");
        }
        JsonObject p = root.getAsJsonObject("product");
        String name = CommerceSyncService.optString(p, "title", "Product " + productId);
        String body = CommerceSyncService.optString(p, "body_html", "");
        String defaultImage = null;
        HashMap<Long, String> imageById = new HashMap<Long, String>();
        if (p.has("image") && !p.get("image").isJsonNull()) {
            defaultImage = CommerceSyncService.optString(p.getAsJsonObject("image"), "src", null);
        }
        if (p.has("images") && p.get("images").isJsonArray()) {
            for (JsonElement ie : p.getAsJsonArray("images")) {
                JsonObject io = ie.getAsJsonObject();
                long iid = io.get("id").getAsLong();
                imageById.put(iid, CommerceSyncService.optString(io, "src", null));
                if (defaultImage != null) continue;
                defaultImage = CommerceSyncService.optString(io, "src", null);
            }
        }
        File outFile = new File(this.plugin.getDataFolder(), "mappings.yml");
        YamlConfiguration y = YamlConfiguration.loadConfiguration((File)outFile);
        JsonArray variants = p.getAsJsonArray("variants");
        for (JsonElement ve : variants) {
            JsonObject v = ve.getAsJsonObject();
            long vid = v.get("id").getAsLong();
            String sku = CommerceSyncService.optString(v, "sku", productId + "-" + vid);
            double price = CommerceSyncService.optDouble(v, "price", -1.0);
            String img = defaultImage;
            if (v.has("image_id") && !v.get("image_id").isJsonNull()) {
                img = imageById.getOrDefault(v.get("image_id").getAsLong(), img);
            }
            String sSku = CommerceSyncService.ensureSku(sku, productId, vid);
            this.writeOrUpdateProductYaml(y, sSku, name, body, price, String.valueOf(productId), String.valueOf(vid), img);
        }
        y.save(outFile);
        this.plugin.getLogger().info("Shopify delta updated product id=" + productId);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getMappingsLoader().load());
    }

    private void writeOrUpdateProductYaml(YamlConfiguration y, String sku, String name, String description, double price, String productId, String variantId, String image) {
        List<Map<String, Object>> actions;
        String base = "products." + sku + ".";
        y.set(base + "name", (Object)name);
        if (description != null && !description.isEmpty()) {
            y.set(base + "description", (Object)CommerceSyncService.stripHtml(description));
        }
        if (price >= 0.0) {
            y.set(base + "price", (Object)price);
        }
        y.set(base + "product_id", (Object)productId);
        if (variantId != null) {
            y.set(base + "variant_id", (Object)variantId);
        } else {
            y.set(base + "variant_id", null);
        }
        if (image != null) {
            y.set(base + "image", (Object)image);
        }
        if (!y.contains(base + "actions") && (actions = this.defaultActionsForSku(sku)) != null) {
            y.set(base + "actions", actions);
        }
    }

    private void ensureCategoriesContainSkus(YamlConfiguration y, List<Long> catIds, String sku) {
        if (catIds == null) {
            return;
        }
        for (String key : y.getConfigurationSection("categories") != null ? y.getConfigurationSection("categories").getKeys(false) : Collections.emptySet()) {
            List skus = y.getStringList("categories." + key + ".skus");
            if (skus.contains(sku)) continue;
            skus.add(sku);
            y.set("categories." + key + ".skus", (Object)skus);
        }
    }

    private HttpResponse<String> authGet(String url, String key, String secret) throws IOException, InterruptedException {
        String auth = Base64.getEncoder().encodeToString((key + ":" + secret).getBytes(StandardCharsets.UTF_8));
        HttpRequest req = HttpRequest.newBuilder(URI.create(url)).timeout(Duration.ofSeconds(30L)).header("Authorization", "Basic " + auth).header("Accept", "application/json").GET().build();
        return this.http.send(req, HttpResponse.BodyHandlers.ofString());
    }

    private HttpResponse<String> shopifyGet(String url, String token) throws IOException, InterruptedException {
        HttpResponse<String> resp;
        int attempts = 0;
        long backoff = 500L;
        do {
            ++attempts;
            HttpRequest req = HttpRequest.newBuilder(URI.create(url)).timeout(Duration.ofSeconds(30L)).header("X-Shopify-Access-Token", token).header("Accept", "application/json").GET().build();
            resp = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() != 429) {
                return resp;
            }
            try {
                Thread.sleep(backoff);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw ie;
            }
            backoff = Math.min(8000L, backoff * 2L);
        } while (attempts <= 5);
        return resp;
    }

    private JsonArray getJsonArray(HttpResponse<String> resp) throws IOException {
        if (resp.statusCode() < 200 || resp.statusCode() >= 300) {
            throw new IOException("HTTP " + resp.statusCode() + ": " + resp.body());
        }
        JsonElement el = JsonParser.parseString(resp.body());
        if (el.isJsonArray()) {
            return el.getAsJsonArray();
        }
        throw new IOException("Unexpected JSON (expected array)");
    }

    private JsonObject getJsonObject(HttpResponse<String> resp) throws IOException {
        if (resp.statusCode() < 200 || resp.statusCode() >= 300) {
            throw new IOException("HTTP " + resp.statusCode() + ": " + resp.body());
        }
        JsonElement el = JsonParser.parseString(resp.body());
        if (el.isJsonObject()) {
            return el.getAsJsonObject();
        }
        throw new IOException("Unexpected JSON (expected object)");
    }

    private List<JsonObject> getAllPagesArrayShopifyCursor(String firstUrl, String token, String arrayKey) throws IOException, InterruptedException {
        JsonArray arr;
        HttpResponse<String> resp;
        JsonObject root;
        ArrayList<JsonObject> out = new ArrayList<JsonObject>();
        String url = firstUrl;
        while ((root = this.getJsonObject(resp = this.shopifyGet(url, token))).has(arrayKey) && (arr = root.getAsJsonArray(arrayKey)).size() != 0) {
            for (JsonElement el : arr) {
                out.add(el.getAsJsonObject());
            }
            Optional<String> next = this.getNextLink(resp.headers().firstValue("Link").orElse(null));
            if (next.isEmpty()) break;
            url = next.get();
        }
        return out;
    }

    private Optional<String> getNextLink(String linkHeader) {
        String[] parts;
        if (linkHeader == null) {
            return Optional.empty();
        }
        for (String p : parts = linkHeader.split(",")) {
            String s2 = p.trim();
            if (!s2.endsWith("rel=\"next\"")) continue;
            int start = s2.indexOf(60);
            int end = s2.indexOf(62);
            if (start < 0 || end <= start) continue;
            return Optional.of(s2.substring(start + 1, end));
        }
        return Optional.empty();
    }

    private static String joinIds(List<Long> ids) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(ids.get(i));
        }
        return sb.toString();
    }

    private static String optString(JsonObject o, String key, String def) {
        return o.has(key) && !o.get(key).isJsonNull() ? o.get(key).getAsString() : def;
    }

    private static double optDouble(JsonObject o, String key, double def) {
        try {
            if (o.has(key) && !o.get(key).isJsonNull()) {
                return Double.parseDouble(o.get(key).getAsString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    private static String ensureSku(String sku, long productId, Long variantId) {
        String s2;
        String string = s2 = sku == null || sku.isBlank() ? String.valueOf(productId) : sku;
        if (variantId != null && (sku == null || sku.isBlank())) {
            return productId + "-" + variantId;
        }
        return s2;
    }

    private static String stripHtml(String s2) {
        return s2.replaceAll("<[^>]*>", "").replaceAll("&nbsp;", " ").trim();
    }

    private static String trimTrailingSlash(String s2) {
        if (s2 == null) {
            return "";
        }
        if (s2.endsWith("/")) {
            return s2.substring(0, s2.length() - 1);
        }
        return s2;
    }

    private static class Category {
        final String key;
        final String name;
        final List<String> skus;
        final String image;

        Category(String k, String n, List<String> s2, String img) {
            this.key = k;
            this.name = n;
            this.skus = s2;
            this.image = img;
        }
    }

    private record Product(String sku, String name, long productId, String variantId, String description, double price, String image) {
    }
}

