/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticladders.block;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import net.alminoris.aestheticladders.block.custom.StoneLadderBlock;
import net.alminoris.aestheticladders.item.ModItems;
import net.alminoris.aestheticladders.util.helper.BlockSetsHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"aestheticladders");
    public static final Dictionary<String, DeferredBlock<Block>> WOODEN_LADDERS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock(name + "_ladder", () -> new LadderBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LADDER))));
            }
        }
    };
    public static final Dictionary<String, DeferredBlock<Block>> STONE_LADDERS = new Hashtable<String, DeferredBlock<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock(name + "_stone_ladder", StoneLadderBlock::new));
            }
        }
    };

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

