/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticladders.datagen;

import net.alminoris.aestheticladders.block.ModBlocks;
import net.alminoris.aestheticladders.item.ModItems;
import net.alminoris.aestheticladders.util.helper.BlockSetsHelper;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "aestheticladders", existingFileHelper);
    }

    protected void registerModels() {
        for (String name : BlockSetsHelper.getWoods()) {
            this.generatedItem(ModItems.WOODEN_STICKS.get(name));
            this.generatedBlockItem(ModBlocks.WOODEN_LADDERS.get(name));
        }
    }

    private ItemModelBuilder generatedItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"aestheticladders", (String)("item/" + item.getId().getPath())));
    }

    private ItemModelBuilder generatedBlockItem(RegistryObject<Block> block) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"aestheticladders", (String)("block/" + block.getId().getPath())));
    }
}

