/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticladders.block;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import net.alminoris.aestheticladders.block.custom.StoneLadderBlock;
import net.alminoris.aestheticladders.item.ModItemGroups;
import net.alminoris.aestheticladders.item.ModItems;
import net.alminoris.aestheticladders.util.helper.BlockSetsHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"aestheticladders");
    public static final Dictionary<String, RegistryObject<Block>> WOODEN_LADDERS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock(name + "_ladder", () -> new LadderBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> STONE_LADDERS = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getStones()) {
                this.put(name, ModBlocks.registerBlock(name + "_stone_ladder", StoneLadderBlock::new));
            }
        }
    };

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(ModItemGroups.ALADRS_TAB)));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

