/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticladders.block.custom;

import java.util.ArrayList;
import net.alminoris.aestheticladders.util.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StoneLadderBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty MOSSED = BooleanProperty.create((String)"mossed");
    private static final VoxelShape SHAPE = StoneLadderBlock.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0);

    public StoneLadderBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)MOSSED, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean currentMossed = (Boolean)state.getValue((Property)MOSSED);
        Direction currentFacing = (Direction)state.getValue((Property)FACING);
        if (stack.getItem() == Blocks.VINE.asItem() && !currentMossed) {
            if (!world.isClientSide) {
                currentMossed = true;
                world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue((Property)MOSSED, (Comparable)Boolean.valueOf(currentMossed)), 3);
                stack.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.getItem() == Items.SHEARS && currentMossed) {
            if (!world.isClientSide) {
                currentMossed = false;
                world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)currentFacing)).setValue((Property)MOSSED, (Comparable)Boolean.valueOf(currentMossed)), 3);
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.getRotatedShape(state);
    }

    private VoxelShape getRotatedShape(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        boxes.add(SHAPE.bounds());
        return VoxelShapeHelper.rotateShape(boxes, direction);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MOSSED});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

