/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.github.talrey.createdeco.blocks.CatwalkStairBlock;
import com.github.talrey.createdeco.blocks.SupportBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CatwalkBlock
extends Block
implements IWrenchable,
ProperWaterloggedBlock {
    private static final VoxelShape VOXEL_TOP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SUPPORTED = Shapes.block();
    public static final BooleanProperty BOTTOM = BlockStateProperties.BOTTOM;

    public CatwalkBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return this.getInteractionShape(state, reader, pos);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.getValue((Property)BOTTOM) != false ? SUPPORTED : VOXEL_TOP;
    }

    private boolean isBottom(BlockGetter level, BlockPos pos) {
        return level.getBlockState(pos.below()).getBlock() instanceof SupportBlock;
    }

    public static boolean isCatwalk(ItemStack test) {
        BlockItem be;
        Item item = test.getItem();
        return item instanceof BlockItem && (be = (BlockItem)item).getBlock() instanceof CatwalkBlock;
    }

    public static boolean isCatwalk(Block test) {
        return test instanceof CatwalkBlock || test instanceof CatwalkStairBlock;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluid = ctx.getLevel().getFluidState(ctx.getClickedPos());
        BlockPos blockPos = ctx.getClickedPos();
        Level level = ctx.getLevel();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((BlockGetter)level, blockPos)));
    }

    public static boolean canPlaceCatwalk(Level world, BlockPos pos) {
        return world.getBlockState(pos).canBeReplaced();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED, BOTTOM});
    }

    public boolean canPlaceLiquid(@Nullable Player playerEntity, BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && fluid == Fluids.WATER;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockState = (BlockState)state.setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((BlockGetter)level, pos)));
        if (state != blockState) {
            level.setBlock(pos, blockState, 3);
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!level.isClientSide) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (!level.isClientSide()) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return state;
    }
}

