package archives.tater.phantomstun.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static java.util.Objects.requireNonNull;

import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1593;
import net.minecraft.class_1937;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;

@Mixin(class_1593.class)
public abstract class PhantomEntitySizeMixin extends class_1309 {
    @Shadow public abstract int getPhantomSize();

    protected PhantomEntitySizeMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @ModifyArg(
            method = "initialize",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/mob/PhantomEntity;setPhantomSize(I)V")
    )
    private int defaultSize(int size) {
        return 1;
    }

    @Inject(
            method = "initialize",
            at = @At("TAIL")
    )
    private void heal(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, CallbackInfoReturnable<class_1315> cir) {
        method_6033(method_6063());
    }

    @Inject(
            method = "onSizeChanged",
            at = @At("TAIL")
    )
    private void setMaxHealth(CallbackInfo ci) {
        requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(20 + 20 * getPhantomSize());
    }
}
