package archives.tater.phantomstun.mixin;

import archives.tater.phantomstun.PhantomStun;
import archives.tater.phantomstun.Stunnable;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1593;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1593.class)
public abstract class PhantomEntityStunMixin extends class_1308 implements Stunnable {
	@Unique
	private int phantomstun$stunnedTicks = 0;

	protected PhantomEntityStunMixin(class_1299<? extends class_1308> entityType, class_1937 world) {
		super(entityType, world);
	}

	@Inject(
			method = "writeCustomData",
			at = @At("TAIL")
	)
	private void writeStun(class_11372 view, CallbackInfo ci) {
		view.method_71465("Stunned", phantomstun$stunnedTicks);
	}

	@Inject(
			method = "readCustomData",
			at = @At("TAIL")
	)
	private void readStun(class_11368 view, CallbackInfo ci) {
		phantomstun$stunnedTicks = view.method_71424("Stunned", 0);
	}

	@Override
	public boolean method_64397(class_3218 serverWorld, class_1282 source, float amount) {
		if (!super.method_64397(serverWorld, source, amount)) return false;

		var sourceEntity = source.method_5526();
		if (source.method_48789(PhantomStun.ALWAYS_STUN_DAMAGE_TAG)
				|| (sourceEntity != null && sourceEntity.method_5864().method_20210(PhantomStun.ALWAYS_STUN_ENTITY_TAG))
				// Players are handled separately
				|| (sourceEntity instanceof class_1309 livingEntity && !(source.method_5529() instanceof class_1657) && source.method_48789(PhantomStun.MELEE_STUN_TAG) && livingEntity.method_67125() > 0)
				|| (sourceEntity instanceof class_1665 projectile && projectile.method_7443())) {
			phantomstun$setStunned();
		}

		return true;
	}

	@Inject(
			method = "tick",
			at = @At("HEAD")
	)
	private void tickStun(CallbackInfo ci) {
        if (phantomstun$stunnedTicks > 0) {
            phantomstun$stunnedTicks--;
		}
	}

	@Override
	public boolean phantomstun$isStunned() {
		return phantomstun$stunnedTicks > 0;
	}

	@Override
	public void phantomstun$setStunned() {
		phantomstun$stunnedTicks = 120;
		method_5980(null);
	}
}
