package archives.tater.phantomstun.mixin;

import archives.tater.phantomstun.Stunnable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1593;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {
    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(
            method = "attack",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;addCritParticles(Lnet/minecraft/entity/Entity;)V")
    )
    private void stunPhantomCrit(class_1297 target, CallbackInfo ci) {
        //noinspection ConstantValue
        if (target instanceof class_1593 && (Object) this instanceof class_3222 && !((Stunnable) target).phantomstun$isStunned()) {
            ((Stunnable) target).phantomstun$setStunned();
        }
    }

    // a bit clunky but this playSound means it was a strong attack (cooldown > 0.9)
    @Inject(
            method = "attack",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/Entity;DDDLnet/minecraft/sound/SoundEvent;Lnet/minecraft/sound/SoundCategory;FF)V", ordinal = 0),
            slice = @Slice(
                    from = @At(value = "FIELD", target = "Lnet/minecraft/sound/SoundEvents;ENTITY_PLAYER_ATTACK_STRONG:Lnet/minecraft/sound/SoundEvent;")
            )
    )
    private void stunPhantomAxe(class_1297 target, CallbackInfo ci) {
        //noinspection ConstantValue
        if (target instanceof class_1593 && (Object) this instanceof class_3222 && !((Stunnable) target).phantomstun$isStunned() && this.method_67125() > 0) {
            ((Stunnable) target).phantomstun$setStunned();
        }
    }
}
