/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.blocks;

import java.util.ArrayList;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.jewelry.blocks.JewelersKitBlock;
import net.jewelry.items.Group;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;

public class JewelryBlocks {
    public static final ArrayList<Entry> all = new ArrayList();
    public static final Entry GEM_VEIN = JewelryBlocks.entry("gem_vein", (Block)new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.0f, 3.0f)));
    public static final Entry DEEPSLATE_GEM_VEIN = JewelryBlocks.entry("deepslate_gem_vein", (Block)new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().mapColor(MapColor.DEEPSLATE).sound(SoundType.DEEPSLATE).strength(4.5f, 3.0f)));
    public static final Entry JEWELERS_KIT = JewelryBlocks.entry("jewelers_kit", new JewelersKitBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).noOcclusion()));

    private static Entry entry(String name, Block block) {
        Entry entry = new Entry(name, block);
        all.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : all) {
            Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)entry.name), (Object)entry.block);
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)entry.name), (Object)entry.item());
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (Entry entry : all) {
                content.accept((ItemLike)entry.item());
            }
        });
    }

    public record Entry(String name, Block block, BlockItem item) {
        public Entry(String name, Block block) {
            this(name, block, new BlockItem(block, new Item.Properties()));
        }
    }
}

