/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.compat;

import io.wispforest.accessories.api.AccessoryItem;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class JewelryAccessoriesItem
extends AccessoryItem {
    private final Supplier<Holder<SoundEvent>> equipSound;
    private final String lore;

    public JewelryAccessoriesItem(Item.Properties properties, String lore, Supplier<Holder<SoundEvent>> equipSound) {
        super(properties);
        this.lore = lore;
        this.equipSound = equipSound;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (this.lore != null && !this.lore.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)this.lore).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD}));
        }
    }

    public SoundEventData getEquipSound(ItemStack stack, SlotReference reference) {
        Holder<SoundEvent> entry = this.equipSound.get();
        if (entry != null) {
            return new SoundEventData(entry, 1.0f, 1.0f);
        }
        return null;
    }
}

