/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.jewelry.config.ItemConfig;
import net.jewelry.items.Group;
import net.jewelry.items.JewelryFactory;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchools;

public class JewelryItems {
    public static final ArrayList<Entry> all = new ArrayList();
    private static final float tier_1_multiplier = 0.04f;
    private static final ItemConfig.Bonus tier_1_bonus = new ItemConfig.Bonus(0.04f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final float tier_2_multiplier = 0.08f;
    private static final ItemConfig.Bonus tier_2_bonus = new ItemConfig.Bonus(0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    public static final String GENERIC_ARMOR = "generic.armor";
    public static final String GENERIC_LUCK = "generic.luck";
    public static final String GENERIC_MOVEMENT_SPEED = "generic.movement_speed";
    public static final String GENERIC_ATTACK_DAMAGE = "generic.attack_damage";
    public static final String GENERIC_MAX_HEALTH = "generic.max_health";
    public static final String GENERIC_ATTACK_SPEED = "generic.attack_speed";
    public static final String GENERIC_ARMOR_TOUGHNESS = "generic.armor_toughness";
    public static final String GENERIC_KNOCKBACK_RESISTANCE = "generic.knockback_resistance";
    public static final String COMBATROLL_RECHARGE = "combat_roll:recharge";
    public static final String COMBATROLL_COUNT = "combat_roll:count";
    public static Entry copper_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"copper_ring"), new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.armor", 0.5f, AttributeModifier.Operation.ADD_VALUE)))).setTier(0);
    public static Entry iron_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"iron_ring"), new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.armor", 1.0f, AttributeModifier.Operation.ADD_VALUE)))).setTier(0);
    public static Entry gold_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"gold_ring"), Rarity.COMMON, true, new ItemConfig.Item(List.of())).setTier(0);
    public static Entry emerald_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"emerald_necklace"), new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.luck", 1.0f, AttributeModifier.Operation.ADD_VALUE)))).setTier(1);
    public static Entry diamond_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"diamond_necklace"), new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.movement_speed", 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(1);
    public static Entry ruby_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"ruby_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_damage", 0.04f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(2);
    public static Entry topaz_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"topaz_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.ARCANE.id, tier_1_bonus), new ItemConfig.AttributeModifier(SpellSchools.FIRE.id, tier_1_bonus)))).setTier(2);
    public static Entry citrine_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"citrine_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.HEALING.id, tier_1_bonus), new ItemConfig.AttributeModifier(SpellSchools.LIGHTNING.id, tier_1_bonus)))).setTier(2);
    public static Entry jade_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"jade_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, 0.04f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(2);
    public static Entry sapphire_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"sapphire_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.max_health", 2.0f, AttributeModifier.Operation.ADD_VALUE)))).setTier(2);
    public static Entry tanzanite_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"tanzanite_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FROST.id, tier_1_bonus), new ItemConfig.AttributeModifier(SpellSchools.SOUL.id, tier_1_bonus)))).setTier(2);
    public static Entry ruby_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"ruby_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_damage", tier_1_bonus)))).setTier(2);
    public static Entry topaz_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"topaz_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.ARCANE.id, tier_1_bonus), new ItemConfig.AttributeModifier(SpellSchools.FIRE.id, tier_1_bonus)))).setTier(2);
    public static Entry citrine_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"citrine_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.HEALING.id, tier_1_bonus), new ItemConfig.AttributeModifier(SpellSchools.LIGHTNING.id, tier_1_bonus)))).setTier(2);
    public static Entry jade_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"jade_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, 0.04f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(2);
    public static Entry sapphire_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"sapphire_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.max_health", 2.0f, AttributeModifier.Operation.ADD_VALUE)))).setTier(2);
    public static Entry tanzanite_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"tanzanite_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FROST.id, tier_1_bonus), new ItemConfig.AttributeModifier(SpellSchools.SOUL.id, tier_1_bonus)))).setTier(2);
    public static Entry netherite_ruby_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"netherite_ruby_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_damage", tier_2_bonus)))).setTier(3);
    public static Entry netherite_topaz_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"netherite_topaz_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.ARCANE.id, tier_2_bonus), new ItemConfig.AttributeModifier(SpellSchools.FIRE.id, tier_2_bonus)))).setTier(3);
    public static Entry netherite_citrine_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"netherite_citrine_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.HEALING.id, tier_2_bonus), new ItemConfig.AttributeModifier(SpellSchools.LIGHTNING.id, tier_2_bonus)))).setTier(3);
    public static Entry netherite_jade_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"netherite_jade_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, tier_2_bonus)))).setTier(3);
    public static Entry netherite_sapphire_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"netherite_sapphire_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.max_health", 4.0f, AttributeModifier.Operation.ADD_VALUE)))).setTier(3);
    public static Entry netherite_tanzanite_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"netherite_tanzanite_ring"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FROST.id, tier_2_bonus), new ItemConfig.AttributeModifier(SpellSchools.SOUL.id, tier_2_bonus)))).setTier(3);
    public static Entry netherite_ruby_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"netherite_ruby_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_damage", 0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(3);
    public static Entry netherite_topaz_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"netherite_topaz_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.ARCANE.id, tier_2_bonus), new ItemConfig.AttributeModifier(SpellSchools.FIRE.id, tier_2_bonus)))).setTier(3);
    public static Entry netherite_citrine_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"netherite_citrine_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.HEALING.id, tier_2_bonus), new ItemConfig.AttributeModifier(SpellSchools.LIGHTNING.id, tier_2_bonus)))).setTier(3);
    public static Entry netherite_jade_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"netherite_jade_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, tier_2_bonus)))).setTier(3);
    public static Entry netherite_sapphire_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"netherite_sapphire_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.max_health", 4.0f, AttributeModifier.Operation.ADD_VALUE)))).setTier(3);
    public static Entry netherite_tanzanite_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"netherite_tanzanite_necklace"), Rarity.UNCOMMON, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FROST.id, tier_2_bonus), new ItemConfig.AttributeModifier(SpellSchools.SOUL.id, tier_2_bonus)))).setTier(3);
    private static final float tier_3_physical_multiplier = 0.12f;
    private static final ItemConfig.Bonus tier_3_primary_bonus = new ItemConfig.Bonus(0.12f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final float tier_3_spell_multiplier = 0.08f;
    private static final float tier_3_ranged_multiplier = 0.08f;
    private static final float tier_3_secondary_multiplier = 0.03f;
    private static final ItemConfig.Bonus tier_3_spell_bonus = new ItemConfig.Bonus(0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    public static Entry unique_attack_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_attack_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_damage", tier_3_primary_bonus), new ItemConfig.AttributeModifier("generic.knockback_resistance", 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_attack_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_attack_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_damage", tier_3_primary_bonus), new ItemConfig.AttributeModifier("generic.knockback_resistance", 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_dex_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_dex_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_speed", 0.06f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier("generic.attack_damage", 0.06f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier("combat_roll:recharge", 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_dex_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_dex_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.attack_speed", 0.06f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier("generic.attack_damage", 0.06f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier("combat_roll:count", 1.0f, AttributeModifier.Operation.ADD_VALUE)))).setTier(4);
    public static Entry unique_tank_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_tank_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.max_health", 6.0f, AttributeModifier.Operation.ADD_VALUE), new ItemConfig.AttributeModifier("generic.armor_toughness", 1.0f, AttributeModifier.Operation.ADD_VALUE)))).setTier(4);
    public static Entry unique_tank_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_tank_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier("generic.max_health", 6.0f, AttributeModifier.Operation.ADD_VALUE), new ItemConfig.AttributeModifier("generic.armor_toughness", 1.0f, AttributeModifier.Operation.ADD_VALUE)))).setTier(4);
    public static Entry unique_archer_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_archer_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, 0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.VELOCITY.id, 0.5f, AttributeModifier.Operation.ADD_VALUE), new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.HASTE.id, 0.04f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_archer_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_archer_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id, 0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier("combat_roll:count", 1.0f, AttributeModifier.Operation.ADD_VALUE), new ItemConfig.AttributeModifier(EntityAttributes_RangedWeapon.HASTE.id, 0.04f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_arcane_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_arcane_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.ARCANE.id, 0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id, 0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_arcane_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_arcane_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.ARCANE.id, 0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id, 0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_fire_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_fire_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FIRE.id, 0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id, 0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_DAMAGE.id, 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_fire_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_fire_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FIRE.id, 0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id, 0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_DAMAGE.id, 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_frost_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_frost_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FROST.id, 0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_DAMAGE.id, 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_frost_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_frost_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.FROST.id, 0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_DAMAGE.id, 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_healing_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_healing_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.HEALING.id, 0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.06f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_healing_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_healing_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.HEALING.id, 0.08f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.06f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_spell_ring = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_spell_ring"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.GENERIC.id, 0.06f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id, 0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new ItemConfig.AttributeModifier(SpellPowerMechanics.HASTE.id, 0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    public static Entry unique_spell_necklace = JewelryItems.add(ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"unique_spell_necklace"), Rarity.RARE, true, new ItemConfig.Item(List.of(new ItemConfig.AttributeModifier(SpellSchools.GENERIC.id, 0.099999994f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).setTier(4);
    private static final ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)"equipment_bonus");

    public static Entry add(ResourceLocation id, ItemConfig.Item config) {
        return JewelryItems.add(id, Rarity.COMMON, config, null, false);
    }

    public static Entry add(ResourceLocation id, Rarity rarity, ItemConfig.Item config) {
        return JewelryItems.add(id, rarity, config, null, false);
    }

    public static Entry add(ResourceLocation id, Rarity rarity, ItemConfig.Item config, boolean fireproof) {
        return JewelryItems.add(id, rarity, config, null, fireproof);
    }

    public static Entry add(ResourceLocation id, Rarity rarity, boolean addLore, ItemConfig.Item config) {
        return JewelryItems.add(id, rarity, config, addLore ? "item." + id.getNamespace() + "." + id.getPath() + ".lore" : null, false);
    }

    public static Entry add(ResourceLocation id, Rarity rarity, ItemConfig.Item config, String lore, boolean fireproof) {
        Entry entry = new Entry(id, rarity, config, lore, fireproof);
        all.add(entry);
        return entry;
    }

    public static void register(ItemConfig allConfigs) {
        for (Entry entry : all) {
            ItemConfig.Item itemConfig = allConfigs.items.get(entry.id.toString());
            if (itemConfig == null) {
                itemConfig = entry.config;
                allConfigs.items.put(entry.id.toString(), entry.config);
            }
            ItemAttributeModifiers.Builder attributes = ItemAttributeModifiers.builder();
            for (ItemConfig.AttributeModifier modifier : itemConfig.attributes) {
                ResourceLocation id = ResourceLocation.parse((String)modifier.id);
                Optional attribute = BuiltInRegistries.ATTRIBUTE.getHolder(id);
                if (attribute.isPresent()) {
                    attributes.add((Holder)attribute.get(), new AttributeModifier(modifierId, (double)modifier.value, modifier.operation), EquipmentSlotGroup.ANY);
                    continue;
                }
                System.err.println("Failed to resolve EntityAttribute with id: " + modifier.id);
            }
            Item.Properties settings = new Item.Properties().rarity(entry.rarity);
            if (entry.fireproof()) {
                settings.fireResistant();
            }
            Item item = entry.create(settings.stacksTo(1), attributes.build());
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id(), (Object)item);
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (Entry entry : all) {
                content.accept((ItemLike)entry.item());
            }
        });
    }

    public static final class Entry {
        private final ResourceLocation id;
        private final Rarity rarity;
        private final ItemConfig.Item config;
        private final String lore;
        private boolean fireproof;
        int tier = 0;
        public Item item;

        public Entry(ResourceLocation id, Rarity rarity, ItemConfig.Item config, String lore, boolean fireproof) {
            this.id = id;
            this.rarity = rarity;
            this.config = config;
            this.lore = lore;
            this.fireproof = fireproof;
        }

        public ResourceLocation id() {
            return this.id;
        }

        public Rarity rarity() {
            return this.rarity;
        }

        public ItemConfig.Item config() {
            return this.config;
        }

        public String lore() {
            return this.lore;
        }

        public boolean fireproof() {
            return this.fireproof;
        }

        public Item create(Item.Properties settings, ItemAttributeModifiers attributes) {
            String slot = this.id.getPath().contains("ring") ? "ring" : (this.id.getPath().contains("necklace") ? "necklace" : null);
            this.item = JewelryFactory.getFactory().apply(new JewelryFactory.ItemArgs(settings, attributes, this.lore, slot));
            return this.item;
        }

        public Item item() {
            return this.item;
        }

        public Entry setTier(int tier) {
            this.tier = tier;
            this.fireproof = tier >= 3;
            return this;
        }

        public int tier() {
            return this.tier;
        }
    }
}

