/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.fabric.compat;

import net.fabricmc.loader.api.FabricLoader;
import net.jewelry.compat.AccessoriesCompat;
import net.jewelry.fabric.compat.FabricCompatConfig;
import net.jewelry.fabric.compat.SpellEngineHelper;
import net.jewelry.fabric.compat.trinkets.TrinketsCompat;
import net.tiny_config.ConfigManager;

public class CompatFeatures {
    private static final ConfigManager<FabricCompatConfig> config = new ConfigManager("fabric_compatibility", (Object)new FabricCompatConfig()).builder().setDirectory("jewelry").sanitize(true).build();

    public static void init() {
        CompatFeatures.initSlotCompat();
    }

    private static void initSlotCompat() {
        FabricCompatConfig loadedConfig = (FabricCompatConfig)config.safeValue();
        String preferred = loadedConfig.preferred_slot_mod;
        try {
            if (FabricLoader.getInstance().isModLoaded("spell_engine")) {
                preferred = SpellEngineHelper.initSlotCompat();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("trinkets".equals(preferred) ? CompatFeatures.initTrinkets() : "accessories".equals(preferred) && CompatFeatures.initAccessories()) {
            return;
        }
        if (CompatFeatures.initTrinkets()) {
            return;
        }
        CompatFeatures.initAccessories();
    }

    private static boolean initTrinkets() {
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            TrinketsCompat.init();
            return true;
        }
        return false;
    }

    private static boolean initAccessories() {
        if (FabricLoader.getInstance().isModLoaded("accessories")) {
            AccessoriesCompat.init();
            return true;
        }
        return false;
    }
}

