/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.jewelry.items.JewelryItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class JewelryDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(UnsmeltGenerator::new);
    }

    public static class UnsmeltGenerator
    extends FabricRecipeProvider {
        public static int UNSMELT_TIME = 300;

        public UnsmeltGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        public void buildRecipes(RecipeOutput exporter) {
            UnsmeltGenerator.disassemble(exporter, List.of(JewelryItems.gold_ring.item()), Items.GOLD_NUGGET);
            UnsmeltGenerator.disassemble(exporter, List.of(JewelryItems.iron_ring.item()), Items.IRON_NUGGET);
            UnsmeltGenerator.disassemble(exporter, List.of(JewelryItems.emerald_necklace.item()), Items.EMERALD);
            UnsmeltGenerator.disassemble(exporter, List.of(JewelryItems.diamond_necklace.item()), Items.DIAMOND);
            UnsmeltGenerator.disassemble(exporter, JewelryItems.all.stream().filter(entry -> entry.tier() == 2).map(entry -> entry.item()).toList(), Items.GOLD_NUGGET);
            UnsmeltGenerator.disassemble(exporter, JewelryItems.all.stream().filter(entry -> entry.id().getPath().contains("netherite")).map(entry -> entry.item()).toList(), Items.NETHERITE_SCRAP);
        }

        private static void disassemble(RecipeOutput exporter, List<ItemLike> items, Item output) {
            FabricRecipeProvider.oreSmelting((RecipeOutput)exporter, items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.oreBlasting((RecipeOutput)exporter, items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }
    }
}

