/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.village;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.jewelry.blocks.JewelryBlocks;
import net.jewelry.items.JewelryItems;
import net.jewelry.util.SoundHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class JewelryVillagers {
    public static final String JEWELER = "jeweler";
    public static VillagerProfession JEWELER_PROFESSION;
    public static ResourceLocation POI_ID;

    public static VillagerProfession createProfession(String name, ResourceKey<PoiType> workStation) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)name);
        return new VillagerProfession(id.toString(), entry -> entry.is(workStation), entry -> entry.is(workStation), ImmutableSet.of(), ImmutableSet.of(), SoundHelper.JEWELRY_WORKBENCH);
    }

    public static void registerPOI() {
        PointOfInterestHelper.register((ResourceLocation)POI_ID, (int)1, (int)10, (Iterable)ImmutableSet.copyOf((Collection)JewelryBlocks.JEWELERS_KIT.block().getStateDefinition().getPossibleStates()));
    }

    public static void registerVillagers() {
        ResourceKey workStation = ResourceKey.create((ResourceKey)BuiltInRegistries.POINT_OF_INTEREST_TYPE.key(), (ResourceLocation)POI_ID);
        JEWELER_PROFESSION = (VillagerProfession)Registry.register((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)JEWELER), (Object)JewelryVillagers.createProfession(JEWELER, (ResourceKey<PoiType>)workStation));
        LinkedHashMap<Integer, List<VillagerTrades.ItemListing>> trades = JewelryVillagers.createTrades();
        for (Map.Entry<Integer, List<VillagerTrades.ItemListing>> entry : trades.entrySet()) {
            TradeOfferHelper.registerVillagerOffers((VillagerProfession)JEWELER_PROFESSION, (int)entry.getKey(), factories -> factories.addAll((Collection)entry.getValue()));
        }
    }

    public static LinkedHashMap<Integer, List<VillagerTrades.ItemListing>> createTrades() {
        LinkedHashMap<Integer, List<VillagerTrades.ItemListing>> trades = new LinkedHashMap<Integer, List<VillagerTrades.ItemListing>>();
        trades.put(1, List.of(new VillagerTrades.EmeraldForItems((ItemLike)Items.COPPER_INGOT, 8, 8, 3, 2), new VillagerTrades.EmeraldForItems((ItemLike)Items.STRING, 7, 6, 3, 2), new VillagerTrades.ItemsForEmeralds(JewelryItems.copper_ring.item(), 4, 1, 12, 4)));
        trades.put(2, List.of(new VillagerTrades.EmeraldForItems((ItemLike)Items.GOLD_INGOT, 7, 8, 2, 8), new VillagerTrades.ItemsForEmeralds(JewelryItems.iron_ring.item(), 4, 1, 6, 5), new VillagerTrades.ItemsForEmeralds(JewelryItems.gold_ring.item(), 18, 1, 6, 5)));
        trades.put(3, List.of(new VillagerTrades.EmeraldForItems((ItemLike)Items.DIAMOND, 1, 12, 10, 10), new VillagerTrades.ItemsForEmeralds(JewelryItems.emerald_necklace.item(), 20, 1, 12, 10), new VillagerTrades.ItemsForEmeralds(JewelryItems.diamond_necklace.item(), 25, 1, 12, 10)));
        trades.put(4, List.of(new VillagerTrades.ItemsForEmeralds(JewelryItems.ruby_ring.item(), 35, 1, 5, 15), new VillagerTrades.ItemsForEmeralds(JewelryItems.topaz_ring.item(), 35, 1, 5, 15), new VillagerTrades.ItemsForEmeralds(JewelryItems.citrine_ring.item(), 35, 1, 5, 15), new VillagerTrades.ItemsForEmeralds(JewelryItems.jade_ring.item(), 35, 1, 5, 15), new VillagerTrades.ItemsForEmeralds(JewelryItems.sapphire_ring.item(), 35, 1, 5, 13), new VillagerTrades.ItemsForEmeralds(JewelryItems.tanzanite_ring.item(), 35, 1, 5, 13)));
        trades.put(5, List.of(new VillagerTrades.ItemsForEmeralds(JewelryItems.ruby_necklace.item(), 45, 1, 3, 15), new VillagerTrades.ItemsForEmeralds(JewelryItems.topaz_necklace.item(), 45, 1, 3, 15), new VillagerTrades.ItemsForEmeralds(JewelryItems.citrine_necklace.item(), 45, 1, 3, 15), new VillagerTrades.ItemsForEmeralds(JewelryItems.jade_necklace.item(), 45, 1, 3, 15), new VillagerTrades.ItemsForEmeralds(JewelryItems.sapphire_necklace.item(), 45, 1, 3, 15), new VillagerTrades.ItemsForEmeralds(JewelryItems.tanzanite_necklace.item(), 45, 1, 3, 15)));
        return trades;
    }

    static {
        POI_ID = ResourceLocation.fromNamespaceAndPath((String)"jewelry", (String)JEWELER);
    }
}

