/*
 * Decompiled with CFR 0.152.
 */
package net.jewelry.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class ItemConfig {
    public Map<String, Item> items = new HashMap<String, Item>();

    public static Item item(List<AttributeModifier> attributes) {
        Item config = new Item(attributes);
        return config;
    }

    public static Item itemWithCondition(String required_mod, List<AttributeModifier> conditionalAttributes, List<AttributeModifier> fallbackAttributes) {
        Item config = new Item(fallbackAttributes);
        config.conditional_attributes = new ConditionalAttributes(required_mod, conditionalAttributes);
        return config;
    }

    public static class Item {
        public ConditionalAttributes conditional_attributes = null;
        public List<AttributeModifier> attributes = List.of();

        Item() {
        }

        public Item(List<AttributeModifier> attributes) {
            this.attributes = attributes;
        }

        public List<AttributeModifier> selectedAttributes() {
            if (this.conditional_attributes != null && this.conditional_attributes.required_mod != null && FabricLoader.getInstance().isModLoaded(this.conditional_attributes.required_mod)) {
                return this.conditional_attributes.attributes();
            }
            return this.attributes;
        }
    }

    public record ConditionalAttributes(String required_mod, List<AttributeModifier> attributes) {
    }

    public static class AttributeModifier {
        public String id = "";
        public float value = 0.0f;
        public AttributeModifier.Operation operation = AttributeModifier.Operation.ADD_VALUE;

        AttributeModifier() {
        }

        public AttributeModifier(ResourceLocation id, float value, AttributeModifier.Operation operation) {
            this(id.toString(), value, operation);
        }

        public AttributeModifier(ResourceLocation id, Bonus bonus) {
            this(id.toString(), bonus.value, bonus.operation);
        }

        public AttributeModifier(String id, Bonus bonus) {
            this(id, bonus.value, bonus.operation);
        }

        public AttributeModifier(String id, float value, AttributeModifier.Operation operation) {
            this.id = id;
            this.value = value;
            this.operation = operation;
        }
    }

    public record Bonus(float value, AttributeModifier.Operation operation) {
    }
}

