/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.client;

import net.atlas.atlascore.AtlasCore;
import net.atlas.atlascore.client.ScreenBuilder;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.config.AtlasConfigScreen;
import net.atlas.atlascore.util.ModRepresentation;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="atlas_core", value={Dist.CLIENT})
public class AtlasCoreClient {
    public static void load(FMLJavaModLoadingContext context) {
        ClientPlayNetworking.registerGlobalReceiver(AtlasCore.AtlasConfigPacket.TYPE, AtlasConfig::handleExtraSyncStatic);
        ClientPlayConnectionEvents.JOIN.register((packet, sender, client) -> sender.sendPacket((FabricPacket)new AtlasCore.ServerboundClientModPacket(ModRepresentation.mapFromModContainers(FabricLoader.getInstance().getAllMods()))));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> AtlasConfig.configs.forEach((resourceLocation, atlasConfig) -> atlasConfig.reload()));
        context.getContainer().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new AtlasConfigScreen((Screen)screen, minecraft.f_91066_, (Component)Component.m_237115_((String)"title.atlas_config.name"))));
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
        ModList.get().forEachModInOrder(modContainer -> {
            if (!AtlasConfig.menus.containsKey(modContainer.getModId())) {
                return;
            }
            AtlasConfig config = AtlasConfig.menus.get(modContainer.getModId());
            modContainer.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> ScreenBuilder.buildAtlasConfig(screen, config)));
        });
    }
}

