/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.config;

import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.atlas.atlascore.config.AtlasConfig;
import net.atlas.atlascore.util.Context;
import net.atlas.atlascore.util.ContextCondition;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.resources.ResourceLocation;

public abstract class ContextBasedConfig
extends AtlasConfig {
    final boolean isGeneric;
    public final ContextCondition contextCondition;
    final ContextBasedConfig generic;
    final List<ContextBasedConfig> subConfigs;

    @Deprecated
    public ContextBasedConfig(ResourceLocation name, AtlasConfig.SyncMode defaultSyncMode, AtlasConfig.ConfigSide configSide, ContextCondition contextCondition) {
        super(name, defaultSyncMode, configSide);
        this.isGeneric = contextCondition.isGeneric();
        this.contextCondition = contextCondition;
        if (!this.isGeneric) {
            this.generic = (ContextBasedConfig)AtlasConfig.configs.get(name);
            this.subConfigs = null;
            this.generic.subConfigs.add(this);
        } else {
            this.generic = this;
            this.subConfigs = new ArrayList<ContextBasedConfig>();
        }
    }

    public static <T extends ContextBasedConfig> T createGeneric(Class<T> tClass, ResourceLocation name) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return ContextBasedConfig.createGeneric(tClass, name, AtlasConfig.SyncMode.OVERRIDE_CLIENT, AtlasConfig.ConfigSide.COMMON);
    }

    public static <T extends ContextBasedConfig> T createGeneric(Class<T> tClass, ResourceLocation name, AtlasConfig.ConfigSide configSide) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return ContextBasedConfig.createGeneric(tClass, name, AtlasConfig.SyncMode.OVERRIDE_CLIENT, configSide);
    }

    public static <T extends ContextBasedConfig> T createGeneric(Class<T> tClass, ResourceLocation name, AtlasConfig.SyncMode defaultSyncMode) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return ContextBasedConfig.createGeneric(tClass, name, defaultSyncMode, AtlasConfig.ConfigSide.COMMON);
    }

    public static <T extends ContextBasedConfig> T createGeneric(Class<T> tClass, ResourceLocation name, AtlasConfig.SyncMode defaultSyncMode, AtlasConfig.ConfigSide configSide) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return (T)((ContextBasedConfig)tClass.getConstructor(ResourceLocation.class, AtlasConfig.SyncMode.class, AtlasConfig.ConfigSide.class, ContextCondition.class).newInstance(new Object[]{name, defaultSyncMode, configSide, ContextCondition.GENERIC}));
    }

    public static <T extends ContextBasedConfig> T createContextual(Class<T> tClass, ResourceLocation name, ContextCondition contextCondition) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return ContextBasedConfig.createContextual(tClass, name, AtlasConfig.SyncMode.OVERRIDE_CLIENT, AtlasConfig.ConfigSide.COMMON, contextCondition);
    }

    public static <T extends ContextBasedConfig> T createContextual(Class<T> tClass, ResourceLocation name, AtlasConfig.ConfigSide configSide, ContextCondition contextCondition) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return ContextBasedConfig.createContextual(tClass, name, AtlasConfig.SyncMode.OVERRIDE_CLIENT, configSide, contextCondition);
    }

    public static <T extends ContextBasedConfig> T createContextual(Class<T> tClass, ResourceLocation name, AtlasConfig.SyncMode defaultSyncMode, ContextCondition contextCondition) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return ContextBasedConfig.createContextual(tClass, name, defaultSyncMode, AtlasConfig.ConfigSide.COMMON, contextCondition);
    }

    public static <T extends ContextBasedConfig> T createContextual(Class<T> tClass, ResourceLocation name, AtlasConfig.SyncMode defaultSyncMode, AtlasConfig.ConfigSide configSide, ContextCondition contextCondition) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return (T)((ContextBasedConfig)tClass.getConstructor(ResourceLocation.class, AtlasConfig.SyncMode.class, AtlasConfig.ConfigSide.class, ContextCondition.class).newInstance(new Object[]{name, defaultSyncMode, configSide, contextCondition}));
    }

    @Override
    protected Path getConfigFolderPath() {
        if (this.isGeneric) {
            return Path.of(String.valueOf(FabricLoader.getInstance().getConfigDir().getFileName().getFileName()) + "/" + this.name.m_135827_(), new String[0]);
        }
        return Path.of(String.valueOf(FabricLoader.getInstance().getConfigDir().getFileName().getFileName()) + "/" + this.name.m_135827_() + "/" + this.contextCondition.name(), new String[0]);
    }

    public ContextBasedConfig getConfig(String name) {
        if (this.contextCondition.name().equals(name)) {
            return this;
        }
        if (this.subConfigs == null) {
            return this.generic.getConfig(name);
        }
        return this.subConfigs.stream().filter(contextBasedConfig -> contextBasedConfig.contextCondition.name().equals(name)).findFirst().orElse(null);
    }

    public ContextBasedConfig getConfig(Context context) {
        if (this.contextCondition.test(context)) {
            return this;
        }
        if (this.subConfigs == null) {
            return this.generic.getConfig(context);
        }
        return this.subConfigs.stream().filter(contextBasedConfig -> contextBasedConfig.contextCondition.test(context)).findFirst().orElse(this);
    }
}

