/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.util;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public record Context(ResourceKey<Level> dimension, Boolean onDedicatedServer) {
    private static final Context EMPTY = new Context(null, null);

    public static Context empty() {
        return EMPTY;
    }

    public ContextBuilder copy() {
        return new ContextBuilder(this);
    }

    public static ContextBuilder builder() {
        return new ContextBuilder(Context.empty());
    }

    public static class ContextBuilder {
        private ResourceKey<Level> dimension;
        private Boolean onDedicatedServer;

        private ContextBuilder(Context base) {
            this.dimension = base.dimension;
            this.onDedicatedServer = base.onDedicatedServer;
        }

        public ContextBuilder applyInformationFromEntity(Entity entity) {
            this.applyInformationFromLevel(entity.m_9236_());
            return this;
        }

        public ContextBuilder applyInformationFromCommandSourceStack(CommandSourceStack commandSourceStack) {
            this.withDimension((ResourceKey<Level>)commandSourceStack.m_81372_().m_46472_());
            this.putOnDedicated(commandSourceStack.m_81377_().m_6982_());
            return this;
        }

        public ContextBuilder applyInformationFromLevel(Level level) {
            this.withDimension((ResourceKey<Level>)level.m_46472_());
            if (!level.m_5776_()) {
                this.putOnDedicated(level.m_7654_().m_6982_());
            }
            return this;
        }

        public ContextBuilder withDimension(ResourceKey<Level> dimension) {
            this.dimension = dimension;
            return this;
        }

        public ContextBuilder putOnDedicated(boolean onDedicatedServer) {
            this.onDedicatedServer = onDedicatedServer;
            return this;
        }

        public Context build() {
            return new Context(this.dimension, this.onDedicatedServer);
        }
    }
}

