/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import net.atlas.atlascore.backport.StreamCodec;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.network.FriendlyByteBuf;

public record ModRepresentation(String name, String modID, Collection<ModRepresentation> provided, Version version) {
    public static final Version UNKNOWN;
    public static final StreamCodec<FriendlyByteBuf, ModRepresentation> CODEC;

    public static ModRepresentation readFromBuf(FriendlyByteBuf buf) {
        Version version;
        String name = buf.m_130277_();
        String modID = buf.m_130277_();
        int providedSize = buf.m_130242_();
        ArrayList<ModRepresentation> provided = new ArrayList<ModRepresentation>();
        for (int i = 0; i < providedSize; ++i) {
            provided.add(ModRepresentation.readFromBuf(buf));
        }
        try {
            version = Version.parse((String)buf.m_130277_());
        }
        catch (VersionParsingException e) {
            version = UNKNOWN;
        }
        return new ModRepresentation(name, modID, Collections.unmodifiableList(provided), version);
    }

    public static void writeToBuf(FriendlyByteBuf buf, ModRepresentation modRepresentation) {
        buf.m_130070_(modRepresentation.name());
        buf.m_130070_(modRepresentation.modID());
        buf.m_130130_(modRepresentation.provided().size());
        for (ModRepresentation str : modRepresentation.provided()) {
            ModRepresentation.writeToBuf(buf, str);
        }
        buf.m_130070_(modRepresentation.version().getFriendlyString());
    }

    public static Collection<ModRepresentation> mapFromModContainers(Collection<ModContainer> mods) {
        return mods.stream().map(modContainer -> {
            if (modContainer.getContainedMods().isEmpty()) {
                return new ModRepresentation(modContainer.getMetadata().getName(), modContainer.getMetadata().getId(), Collections.emptyList(), modContainer.getMetadata().getVersion());
            }
            return new ModRepresentation(modContainer.getMetadata().getName(), modContainer.getMetadata().getId(), ModRepresentation.mapFromModContainers(modContainer.getContainedMods()), modContainer.getMetadata().getVersion());
        }).toList();
    }

    public void list(Consumer<String> stringConsumer, Function<ModRepresentation, String> name, String prefix) {
        stringConsumer.accept(prefix + name.apply(this) + ": " + String.valueOf(this.version()));
        if (!this.provided.isEmpty()) {
            this.provided.stream().sorted(Comparator.comparing(name)).forEach(modRepresentation -> modRepresentation.list(string -> stringConsumer.accept("  " + string), name, prefix));
        }
    }

    static {
        try {
            UNKNOWN = Version.parse((String)"1.0.0-UNKNOWN");
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
        CODEC = StreamCodec.of(ModRepresentation::writeToBuf, ModRepresentation::readFromBuf);
    }
}

