/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.atlascore.backport;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.atlas.atlascore.backport.StreamCodec;
import net.minecraft.class_2359;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2509;
import net.minecraft.class_2540;

public interface ByteBufCodecs {
    public static final int MAX_INITIAL_COLLECTION_SIZE = 65536;
    public static final StreamCodec<ByteBuf, Boolean> BOOL = new StreamCodec<ByteBuf, Boolean>(){

        @Override
        public Boolean decode(ByteBuf byteBuf) {
            return byteBuf.readBoolean();
        }

        @Override
        public void encode(ByteBuf byteBuf, Boolean boolean_) {
            byteBuf.writeBoolean(boolean_.booleanValue());
        }
    };
    public static final StreamCodec<ByteBuf, Byte> BYTE = new StreamCodec<ByteBuf, Byte>(){

        @Override
        public Byte decode(ByteBuf byteBuf) {
            return byteBuf.readByte();
        }

        @Override
        public void encode(ByteBuf byteBuf, Byte byte_) {
            byteBuf.writeByte((int)byte_.byteValue());
        }
    };
    public static final StreamCodec<ByteBuf, Short> SHORT = new StreamCodec<ByteBuf, Short>(){

        @Override
        public Short decode(ByteBuf byteBuf) {
            return byteBuf.readShort();
        }

        @Override
        public void encode(ByteBuf byteBuf, Short short_) {
            byteBuf.writeShort((int)short_.shortValue());
        }
    };
    public static final StreamCodec<ByteBuf, Integer> UNSIGNED_SHORT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf byteBuf) {
            return byteBuf.readUnsignedShort();
        }

        @Override
        public void encode(ByteBuf byteBuf, Integer integer) {
            byteBuf.writeShort(integer.intValue());
        }
    };
    public static final StreamCodec<ByteBuf, Integer> INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf byteBuf) {
            return byteBuf.readInt();
        }

        @Override
        public void encode(ByteBuf byteBuf, Integer integer) {
            byteBuf.writeInt(integer.intValue());
        }
    };
    public static final StreamCodec<ByteBuf, Integer> VAR_INT = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf byteBuf) {
            return new class_2540(byteBuf).method_10816();
        }

        @Override
        public void encode(ByteBuf byteBuf, Integer integer) {
            new class_2540(byteBuf).method_10804(integer.intValue());
        }
    };
    public static final StreamCodec<ByteBuf, Long> VAR_LONG = new StreamCodec<ByteBuf, Long>(){

        @Override
        public Long decode(ByteBuf byteBuf) {
            return new class_2540(byteBuf).method_10792();
        }

        @Override
        public void encode(ByteBuf byteBuf, Long l) {
            new class_2540(byteBuf).method_10791(l.longValue());
        }
    };
    public static final StreamCodec<ByteBuf, Float> FLOAT = new StreamCodec<ByteBuf, Float>(){

        @Override
        public Float decode(ByteBuf byteBuf) {
            return Float.valueOf(byteBuf.readFloat());
        }

        @Override
        public void encode(ByteBuf byteBuf, Float float_) {
            byteBuf.writeFloat(float_.floatValue());
        }
    };
    public static final StreamCodec<ByteBuf, Double> DOUBLE = new StreamCodec<ByteBuf, Double>(){

        @Override
        public Double decode(ByteBuf byteBuf) {
            return byteBuf.readDouble();
        }

        @Override
        public void encode(ByteBuf byteBuf, Double double_) {
            byteBuf.writeDouble(double_.doubleValue());
        }
    };
    public static final StreamCodec<class_2540, byte[]> BYTE_ARRAY = new StreamCodec<class_2540, byte[]>(){

        @Override
        public byte[] decode(class_2540 friendlyByteBuf) {
            return friendlyByteBuf.method_10795();
        }

        @Override
        public void encode(class_2540 friendlyByteBuf, byte[] bs) {
            friendlyByteBuf.method_10813(bs);
        }
    };
    public static final StreamCodec<class_2540, String> STRING_UTF8 = ByteBufCodecs.stringUtf8(Short.MAX_VALUE);
    public static final StreamCodec<class_2540, class_2487> COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(() -> new class_2505(0x200000L));
    public static final StreamCodec<class_2540, class_2487> TRUSTED_COMPOUND_TAG = ByteBufCodecs.compoundTagCodec(() -> class_2505.field_11556);
    public static final StreamCodec<class_2540, Optional<class_2487>> OPTIONAL_COMPOUND_TAG = new StreamCodec<class_2540, Optional<class_2487>>(){

        @Override
        public Optional<class_2487> decode(class_2540 friendlyByteBuf) {
            return Optional.ofNullable(friendlyByteBuf.method_10798());
        }

        @Override
        public void encode(class_2540 friendlyByteBuf, Optional<class_2487> optional) {
            friendlyByteBuf.method_10794((class_2487)optional.orElse(null));
        }
    };

    public static StreamCodec<class_2540, byte[]> byteArray(final int i) {
        return new StreamCodec<class_2540, byte[]>(){

            @Override
            public byte[] decode(class_2540 friendlyByteBuf) {
                return friendlyByteBuf.method_10803(i);
            }

            @Override
            public void encode(class_2540 friendlyByteBuf, byte[] bs) {
                if (bs.length > i) {
                    throw new EncoderException("ByteArray with size " + bs.length + " is bigger than allowed " + i);
                }
                friendlyByteBuf.method_10813(bs);
            }
        };
    }

    public static StreamCodec<class_2540, String> stringUtf8(final int i) {
        return new StreamCodec<class_2540, String>(){

            @Override
            public String decode(class_2540 friendlyByteBuf) {
                return friendlyByteBuf.method_10800(i);
            }

            @Override
            public void encode(class_2540 friendlyByteBuf, String string) {
                friendlyByteBuf.method_10788(string, i);
            }
        };
    }

    public static StreamCodec<class_2540, class_2487> compoundTagCodec(final Supplier<class_2505> supplier) {
        return new StreamCodec<class_2540, class_2487>(){

            @Override
            public class_2487 decode(class_2540 friendlyByteBuf) {
                class_2487 tag = friendlyByteBuf.method_30616((class_2505)supplier.get());
                if (tag == null) {
                    throw new DecoderException("Expected non-null compound tag");
                }
                return tag;
            }

            @Override
            public void encode(class_2540 friendlyByteBuf, class_2487 tag) {
                friendlyByteBuf.method_10794(tag);
            }
        };
    }

    public static <T> StreamCodec<class_2540, T> fromCodec(final Codec<T> codec) {
        return new StreamCodec<class_2540, T>(){

            @Override
            public T decode(class_2540 object) {
                return object.method_29171((DynamicOps)class_2509.field_11560, codec);
            }

            @Override
            public void encode(class_2540 object, T object2) {
                object.method_29172((DynamicOps)class_2509.field_11560, codec, object2);
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec<B, Optional<V>> optional(final StreamCodec<B, V> streamCodec) {
        return new StreamCodec<B, Optional<V>>(){

            @Override
            public Optional<V> decode(B byteBuf) {
                return byteBuf.readBoolean() ? Optional.of(streamCodec.decode(byteBuf)) : Optional.empty();
            }

            @Override
            public void encode(B byteBuf, Optional<V> optional) {
                if (optional.isPresent()) {
                    byteBuf.writeBoolean(true);
                    streamCodec.encode(byteBuf, optional.get());
                } else {
                    byteBuf.writeBoolean(false);
                }
            }
        };
    }

    public static int readCount(ByteBuf byteBuf, int maxElements) {
        int count = ByteBufCodecs.readVarInt(byteBuf);
        if (count > maxElements) {
            throw new DecoderException(count + " elements exceeded max size of: " + maxElements);
        }
        return count;
    }

    public static void writeCount(ByteBuf byteBuf, int count, int maxElements) {
        if (count > maxElements) {
            throw new EncoderException(count + " elements exceeded max size of: " + maxElements);
        }
        ByteBufCodecs.writeVarInt(byteBuf, count);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(IntFunction<C> intFunction, StreamCodec<? super B, V> streamCodec) {
        return ByteBufCodecs.collection(intFunction, streamCodec, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(final IntFunction<C> intFunction, final StreamCodec<? super B, V> streamCodec, final int maxElements) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B byteBuf) {
                int cnt = ByteBufCodecs.readCount(byteBuf, maxElements);
                Collection collection = (Collection)intFunction.apply(Math.min(cnt, 65536));
                for (int j = 0; j < cnt; ++j) {
                    collection.add(streamCodec.decode(byteBuf));
                }
                return collection;
            }

            @Override
            public void encode(B byteBuf, C collection) {
                ByteBufCodecs.writeCount(byteBuf, collection.size(), maxElements);
                for (Object object : collection) {
                    streamCodec.encode(byteBuf, object);
                }
            }
        };
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec.CodecOperation<B, V, C> collection(IntFunction<C> intFunction) {
        return streamCodec -> ByteBufCodecs.collection(intFunction, streamCodec);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list() {
        return streamCodec -> ByteBufCodecs.collection(ArrayList::new, streamCodec);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list(int i) {
        return streamCodec -> ByteBufCodecs.collection(ArrayList::new, streamCodec, i);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(IntFunction<? extends M> intFunction, StreamCodec<? super B, K> streamCodec, StreamCodec<? super B, V> streamCodec2) {
        return ByteBufCodecs.map(intFunction, streamCodec, streamCodec2, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> map(final IntFunction<? extends M> intFunction, final StreamCodec<? super B, K> streamCodec, final StreamCodec<? super B, V> streamCodec2, final int maxElements) {
        return new StreamCodec<B, M>(){

            @Override
            public void encode(B byteBuf, M map) {
                ByteBufCodecs.writeCount(byteBuf, map.size(), maxElements);
                map.forEach((object, object2) -> {
                    streamCodec.encode(byteBuf, object);
                    streamCodec2.encode(byteBuf, object2);
                });
            }

            @Override
            public M decode(B byteBuf) {
                int cnt = ByteBufCodecs.readCount(byteBuf, maxElements);
                Map map = (Map)intFunction.apply(Math.min(cnt, 65536));
                for (int j = 0; j < cnt; ++j) {
                    Object object = streamCodec.decode(byteBuf);
                    Object object2 = streamCodec2.decode(byteBuf);
                    map.put(object, object2);
                }
                return map;
            }
        };
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, Either<L, R>> either(final StreamCodec<? super B, L> streamCodec, final StreamCodec<? super B, R> streamCodec2) {
        return new StreamCodec<B, Either<L, R>>(){

            @Override
            public Either<L, R> decode(B byteBuf) {
                return byteBuf.readBoolean() ? Either.left(streamCodec.decode(byteBuf)) : Either.right(streamCodec2.decode(byteBuf));
            }

            @Override
            public void encode(B byteBuf, Either<L, R> either) {
                either.ifLeft(object -> {
                    byteBuf.writeBoolean(true);
                    streamCodec.encode(byteBuf, object);
                }).ifRight(object -> {
                    byteBuf.writeBoolean(false);
                    streamCodec2.encode(byteBuf, object);
                });
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(final IntFunction<T> intFunction, final ToIntFunction<T> toIntFunction) {
        return new StreamCodec<ByteBuf, T>(){

            @Override
            public T decode(ByteBuf byteBuf) {
                int i = ByteBufCodecs.readVarInt(byteBuf);
                return intFunction.apply(i);
            }

            @Override
            public void encode(ByteBuf byteBuf, T object) {
                int i = toIntFunction.applyAsInt(object);
                ByteBufCodecs.writeVarInt(byteBuf, i);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> idMapper(class_2359<T> idMap) {
        Objects.requireNonNull(idMap);
        return ByteBufCodecs.idMapper(arg_0 -> idMap.method_39974(arg_0), arg_0 -> idMap.method_10206(arg_0));
    }

    public static int readVarInt(ByteBuf buf) {
        byte b;
        int i = 0;
        int j = 0;
        do {
            b = buf.readByte();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b & 0x80) == 128);
        return i;
    }

    public static long readVarLong(ByteBuf buf) {
        byte b;
        long l = 0L;
        int i = 0;
        do {
            b = buf.readByte();
            l |= (long)(b & 0x7F) << i++ * 7;
            if (i <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((b & 0x80) == 128);
        return l;
    }

    public static ByteBuf writeVarInt(ByteBuf buf, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            buf.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        buf.writeByte(i);
        return buf;
    }

    public static ByteBuf writeVarLong(ByteBuf buf, long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buf.writeByte((int)(l & 0x7FL) | 0x80);
            l >>>= 7;
        }
        buf.writeByte((int)l);
        return buf;
    }
}

